% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jstree.R
\name{jstree}
\alias{jstree}
\title{HTML widget displaying an interactive tree}
\usage{
jstree(
  nodes,
  elementId = NULL,
  checkboxes = FALSE,
  search = FALSE,
  searchtime = 250,
  dragAndDrop = FALSE,
  dnd = NULL,
  multiple = TRUE,
  types = NULL,
  sort = FALSE,
  unique = FALSE,
  wholerow = FALSE,
  contextMenu = FALSE,
  checkCallback = NULL,
  grid = NULL,
  theme = "default"
)
}
\arguments{
\item{nodes}{data, a list of nodes; each node is a list with a required
field \code{text}, a character string labeling the node, and optional
fields
\describe{
  \item{\code{children}}{
    a list of nodes
  }
  \item{\code{data}}{
    a named list of data to attach to the node; see the
    \link[jsTreeR:jstreeOutput]{Shiny examples}
  }
  \item{\code{icon}}{
    space-separated HTML class names defining an icon, e.g.
    \code{"glyphicon glyphicon-flash"}; in a Shiny app you can also use
    a super tiny icon, e.g. \code{"supertinyicon-julia"}; see the
    \link[jsTreeR:jstreeOutput]{Shiny example} showing all available such
    icons
  }
  \item{\code{type}}{
    a character string for usage with the \code{types} option; see first
    example
  }
  \item{\code{state}}{
    a named list defining the state of the node, with four possible fields,
    each being \code{TRUE} or \code{FALSE}:
    \describe{
      \item{\code{opened}}{
        whether the node should be initially opened
      }
      \item{\code{selected}}{
        whether the node should be initially selected
      }
      \item{\code{disabled}}{
        whether the node should be disabled
      }
      \item{\code{checked}}{
        whether the node should be initially checked, effective
        only when the \code{checkboxes} option is \code{TRUE}
      }
    }
  }
  \item{\code{a_attr}}{
    a named list of attributes for the node label, such as
    \code{list(title = "I'm a tooltip", style = "color: red;")}
  }
  \item{\code{li_attr}}{
    a named list of attributes for the whole node, including its children,
    such as
    \code{list(title = "I'm a tooltip", style = "background-color: pink;")}
  }
}}

\item{elementId}{a HTML id for the widget (useless for common usage)}

\item{checkboxes}{logical, whether to enable checkboxes next to each node;
this makes easier the selection of multiple nodes}

\item{search}{either a logical value, whether to enable the search
functionality with default options, or a named list of options for the
search functionality; see the \link[jsTreeR:jstreeOutput]{Shiny example}
and the \href{https://www.jstree.com/api/}{jsTree API documentation} for
the list of possible options}

\item{searchtime}{currently ignored}

\item{dragAndDrop}{logical, whether to allow the rearrangement of the nodes
by dragging and dropping}

\item{dnd}{a named list of options related to the drag-and-drop
functionality, e.g. the \code{is_draggable} function to define which nodes
are draggable; see the first example and the
\href{https://www.jstree.com/api/}{jsTree API documentation} for the list
of possible options}

\item{multiple}{logical, whether to allow multiselection}

\item{types}{a named list of node properties; see first example}

\item{sort}{logical, whether to sort the nodes}

\item{unique}{logical, whether to ensure that no node label is duplicated}

\item{wholerow}{logical, whether to highlight whole selected rows}

\item{contextMenu}{either a logical value, whether to enable a context menu
to create/rename/delete/cut/copy/paste nodes, or a list of options; see
the \href{https://www.jstree.com/api/}{jsTree API documentation} for the
possible options}

\item{checkCallback}{either \code{TRUE} to allow to perform some actions
such as creating a new node, or a JavaScript function; see the example
where this option is used to define restrictions on the drag-and-drop
behavior}

\item{grid}{list of settings for the grid; see the second example, the
\link[jsTreeR:jstreeOutput]{Shiny example}, and
\href{https://github.com/deitch/jstree-grid/#options}{github.com/deitch/jstree-grid}
for the list of all available options}

\item{theme}{jsTree theme, one of \code{"default"},
\code{"default-dark"}, or \code{"proton"}}
}
\description{
Create a HTML widget displaying an interactive tree.
}
\examples{
# example illustrating the 'dnd' and 'checkCallback' options ####

library(jsTreeR)

nodes <- list(
  list(
    text = "RootA",
    type = "root",
    children = list(
      list(
        text = "ChildA1",
        type = "child"
      ),
      list(
        text = "ChildA2",
        type = "child"
      )
    )
  ),
  list(
    text = "RootB",
    type = "root",
    children = list(
      list(
        text = "ChildB1",
        type = "child"
      ),
      list(
        text = "ChildB2",
        type = "child"
      )
    )
  )
)

types <- list(
  root = list(
    icon = "glyphicon glyphicon-ok"
  ),
  child = list(
    icon = "glyphicon glyphicon-file"
  )
)

checkCallback <- JS(
  "function(operation, node, parent, position, more) {",
  "  if(operation === 'move_node') {",
  "    if(parent.id === '#' || parent.type === 'child') {",
  "      return false;", # prevent moving a child above or below the root
  "    }",               # and moving inside a child
  "  }",
  "  return true;", # allow everything else
  "}"
)

dnd <- list(
  is_draggable = JS(
    "function(node) {",
    "  return node[0].type === 'child';",
    "}"
  )
)

jstree(
  nodes,
  dragAndDrop = TRUE, dnd = dnd,
  types = types,
  checkCallback = checkCallback
)


# example illustrating the 'grid' option ####

library(jsTreeR)

nodes <- list(
  list(
    text = "Products",
    children = list(
      list(
        text = "Fruit",
        children = list(
          list(
            text = "Apple",
            data = list(
              price = 0.1,
              quantity = 20
            )
          ),
          list(
            text = "Banana",
            data = list(
              price = 0.2,
              quantity = 31
            )
          ),
          list(
            text = "Grapes",
            data = list(
              price = 1.99,
              quantity = 34
            )
          ),
          list(
            text = "Mango",
            data = list(
              price = 0.5,
              quantity = 8
            )
          ),
          list(
            text = "Melon",
            data = list(
              price = 0.8,
              quantity = 4
            )
          ),
          list(
            text = "Pear",
            data = list(
              price = 0.1,
              quantity = 30
            )
          ),
          list(
            text = "Strawberry",
            data = list(
              price = 0.15,
              quantity = 32
            )
          )
        ),
        state = list(
          opened = TRUE
        )
      ),
      list(
        text = "Vegetables",
        children = list(
          list(
            text = "Aubergine",
            data = list(
              price = 0.5,
              quantity = 8
            )
          ),
          list(
            text = "Broccoli",
            data = list(
              price = 0.4,
              quantity = 22
            )
          ),
          list(
            text = "Carrot",
            data = list(
              price = 0.1,
              quantity = 32
            )
          ),
          list(
            text = "Cauliflower",
            data = list(
              price = 0.45,
              quantity = 18
            )
          ),
          list(
            text = "Potato",
            data = list(
              price = 0.2,
              quantity = 38
            )
          )
        )
      )
    ),
    state = list(
      opened = TRUE
    )
  )
)

grid <- list(
  columns = list(
    list(
      width = 200,
      header = "Name"
    ),
    list(
      width = 150,
      value = "price",
      header = "Price"
    ),
    list(
      width = 150,
      value = "quantity",
      header = "Qty"
    )
  ),
  width = 600
)

jstree(nodes, grid = grid)
}
