% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bonds.R
\name{bonds}
\alias{bond.TCF}
\alias{bond.duration}
\alias{bond.durations}
\alias{bond.price}
\alias{bond.prices}
\alias{bond.yield}
\alias{bond.yields}
\alias{bonds}
\title{Bond pricing using yield to maturity.}
\usage{
bond.price(settle, mature, coupon, freq = 2, yield, convention = c("30/360",
  "ACT/ACT", "ACT/360", "30/360E"), comp.freq = freq)

bond.yield(settle, mature, coupon, freq = 2, price, convention = c("30/360",
  "ACT/ACT", "ACT/360", "30/360E"), comp.freq = freq)

bond.duration(settle, mature, coupon, freq = 2, yield,
  convention = c("30/360", "ACT/ACT", "ACT/360", "30/360E"),
  modified = FALSE, comp.freq = freq)

bond.TCF(settle, mature, coupon, freq = 2, convention = c("30/360",
  "ACT/ACT", "ACT/360", "30/360E"))

bond.prices(settle, mature, coupon, freq = 2, yield,
  convention = c("30/360", "ACT/ACT", "ACT/360", "30/360E"),
  comp.freq = freq)

bond.yields(settle, mature, coupon, freq = 2, price,
  convention = c("30/360", "ACT/ACT", "ACT/360", "30/360E"),
  comp.freq = freq)

bond.durations(settle, mature, coupon, freq = 2, yield,
  convention = c("30/360", "ACT/ACT", "ACT/360", "30/360E"),
  modified = FALSE, comp.freq = freq)
}
\arguments{
\item{settle}{The settlement date for which the bond is traded. Can be a
character string or any object that can be converted into date using
\code{\link{as.Date}}.}

\item{mature}{The maturity date of the bond. Can be a character string or
any object that can be converted into date using \code{\link{as.Date}}}

\item{coupon}{The coupon rate in decimal (0.10 or 10e-2 for 10\%)}

\item{freq}{The frequency of coupon payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}

\item{yield}{The yield to maturity of the bond}

\item{convention}{The daycount convention}

\item{comp.freq}{The frequency of compounding of the bond yield: 1 for
annual, 2 for semi-annual, 12 for monthly. Usually same as freq.}

\item{price}{The clean price of the bond.}

\item{modified}{A logical value used in duration. \code{TRUE} to return Modified
Duration, \code{FALSE} otherwise}
}
\value{
\code{bond.TCF} returns a list of three components
\item{t}{A vector of cash flow dates in number of years}
\item{cf}{A vector of cash flows}
\item{accrued}{The accrued interest}
}
\description{
bond.price computes the price given the yield to maturity
bond.duration computes the duration given the yield to maturity
bond.yield computes the yield to maturity given the price
bond.prices, bond.durations and bond.yields are wrapper functions
that use mapply to vectorize bond.price, bond.duration and bond.yield
All arguments to bond.prices, bond.durations and bond.yields
can be vectors.
On the other hand, bond.price, bond.duration and bond.yield do not allow vectors
Standard compounding and day count conventions are supported for all functions.
}
\author{
Prof. Jayanth R. Varma \email{jrvarma@iimahd.ernet.in}
}

