% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind_bib.R
\name{rbind_bib}
\alias{rbind_bib}
\title{Merging multiple Bib file}
\usage{
rbind_bib(..., fill = FALSE)
}
\arguments{
\item{...}{(generalized) tibble or data.frame.}

\item{fill}{logical,if \code{TRUE} the fills missing columns with NAs. By default FALSE.}
}
\value{
A \code{tibble}.
}
\description{
Use \code{read_bib2tib} to read multiple Bib files. For example, the returned objects are tib1, rib2,tib3 ,.... In general, the column names of tib1, tib2,..., etc. are not the same. Therefore, this function is used to merge tib1, TiB2,.... if the column name does not exist, let it be NA
}
\examples{
# Read from .bib file:
require(journalabbr)
path1 = system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
path2 = system.file("extdata", "testfile_3.bib", package = "journalabbr", mustWork = TRUE)
path3 = system.file("extdata", "testfile_4.bib", package = "journalabbr", mustWork = TRUE)
tib1 <- read_bib2tib(path1)
tib2 <- read_bib2tib(path2)
tib3 <- read_bib2tib(path3)
df = rbind_bib(tib1,tib2,fill=TRUE)
df1 = rbind_bib(tib1,tib2,tib3,fill=TRUE)
## dont run
# rbind_bib(tib1,tib2)
}
\author{
ShuCai Zou
}
