% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interop-utils.R
\name{julia_progress}
\alias{julia_progress}
\title{Set/get options for Julia progress bar}
\usage{
julia_progress(show, width)
}
\arguments{
\item{show}{Whether to show the progress bar. You may also pass in a list of \code{"show"} and \code{"width"}.}

\item{width}{Width of the progress bar. If \code{"auto"}, adjusts the progress bar width to fit the console.}
}
\value{
Previous values for \code{show} and \code{width}
}
\description{
Set/get options for Julia progress bar
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(cache_dir = tempdir(), verbose = FALSE)
}

# Show current progress options
julia_progress()

# Set options and save previous options
old_progress_opts <- julia_progress(show = FALSE, width = 100)
julia_progress()

# Restoring progress settings by passing a list of old options
old_progress_opts
julia_progress(old_progress_opts)
identical(julia_progress(), old_progress_opts)

# Alternatively, reset to default settings using this syntax:
julia_progress(show = TRUE, width = "auto")

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
