% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/visualizations.R
\name{boxplot.james}
\alias{boxplot.james}
\title{Solution quality and convergence time box plots}
\usage{
\method{boxplot}{james}(x, problem, type = c("quality", "time"), r = 0.99,
  title, subtitle, ylab, names, ...)
}
\arguments{
\item{x}{data object containing the analysis results}

\item{problem}{name of the problem for which the plot is made. Can be omitted
if the data \code{x} contains results for a single problem only.}

\item{type}{one of \code{"quality"} (default) or \code{"time"}. If set to
"quality", the final solution's value is reported; if set to "time", the
time until convergence is reported. In both cases, the respective
distribution of values found during the different search runs is shown. In
the latter case, the argument \code{r} is used to decide when a search run
has converged.}

\item{r}{convergence ratio, only used if \code{type} is \code{"time"}.
Defaults to 0.99. Should be a numeric value in [0,1].}

\item{title}{plot title. Defaults to \code{"Solution quality"} or
\code{"Convergence time"} when \code{type} is set to \code{"quality"} or
\code{"time"}, respectively.}

\item{subtitle}{plot subtitle. By default, a subtitle is added that states
the name of the problem for which the plot is made. If \code{type} is
\code{"time"} the subtitle also mentions the applied convergence ratio
\code{r}. If no subtitle is desired set \code{subtitle = ""}.}

\item{ylab}{y-axis label. Defaults to \code{"Value"} or \code{"Time (ms)"}
when \code{type} is set to \code{"quality"} or \code{"time"}, respectively.}

\item{names}{names to be shown on the x-axis under the box plots. Defaults to
the search names obtained from calling \code{\link{getSearches}} on the
given data \code{x} and \code{problem}.}

\item{...}{any additional parameters are passed to \code{\link{boxplot}}.}
}
\description{
Produce box-and-whisker plots for the searches that have been applied to the
given problem, visualizing the distribution of the best found solution's
value (solution quality) or time until convergence in subsequent search runs.
}
\details{
If the data \code{x} contains results for a single problem only, the argument
\code{problem} can be omitted. If desired to produce box plots for a
selection of the applied searches, use \code{\link{reduceJAMES}} to extract
the respective data.

Convergence times are computed with \code{\link{getConvergenceTimes}}.

The plots are made using the generic \code{\link{boxplot}} method called on a
list of vectors containing the distribution samples for each search.

Any additional parameters are passed to \code{\link{boxplot}}.
}
\seealso{
\code{\link{getConvergenceTimes}}, \code{\link{boxplot}}
}

