% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{cPaste}
\alias{cPaste}
\alias{cPasteS}
\alias{cPasteSU}
\alias{cPasteUnique}
\alias{cPasteU}
\title{paste a list into a delimited vector}
\usage{
cPaste(
  x,
  sep = ",",
  doSort = FALSE,
  makeUnique = FALSE,
  na.rm = FALSE,
  keepFactors = FALSE,
  checkClass = TRUE,
  useBioc = TRUE,
  useLegacy = FALSE,
  honorFactor = TRUE,
  verbose = FALSE,
  ...
)

cPasteS(
  x,
  sep = ",",
  doSort = TRUE,
  makeUnique = FALSE,
  na.rm = FALSE,
  keepFactors = FALSE,
  checkClass = TRUE,
  useBioc = TRUE,
  ...
)

cPasteSU(
  x,
  sep = ",",
  doSort = TRUE,
  makeUnique = TRUE,
  na.rm = FALSE,
  keepFactors = FALSE,
  checkClass = TRUE,
  useBioc = TRUE,
  ...
)

cPasteUnique(
  x,
  sep = ",",
  doSort = FALSE,
  makeUnique = TRUE,
  na.rm = FALSE,
  keepFactors = FALSE,
  checkClass = TRUE,
  useBioc = TRUE,
  ...
)

cPasteU(
  x,
  sep = ",",
  doSort = FALSE,
  makeUnique = TRUE,
  na.rm = FALSE,
  keepFactors = FALSE,
  checkClass = TRUE,
  useBioc = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{list} of vectors}

\item{sep}{\code{character} delimiter used to paste multiple values together}

\item{doSort}{\code{logical} indicating whether to sort each vector
using \code{\link[=mixedOrder]{mixedOrder()}}.}

\item{makeUnique}{\code{logical} indicating whether to make each vector in
the input list unique before pasting its values together.}

\item{na.rm}{\code{logical} indicating whether to remove NA values from
each vector in the input list. When \code{na.rm} is \code{TRUE} and a
list element contains only \code{NA} values, the resulting string
will be \code{""}.}

\item{keepFactors}{\code{logical} only used when \code{useLegacy=TRUE} and
\code{doSort=TRUE}; indicating whether to preserve factors,
keeping factor level order. When
\code{keepFactors=TRUE}, if any list element is a \code{factor}, all elements
are converted to factors. Note that this step combines overall
factor levels, and non-factors will be ordered using
\code{base::order()} instead of \code{jamba::mixedOrder()} (for now.)}

\item{checkClass}{\code{logical}, default TRUE, whether to check the class
of each vector in the input list.
\itemize{
\item When TRUE, it confirms the class of each element in the \code{list}
before processing, to prevent conversion which may otherwise
lose information.
\item For all cases when a known vector is split into a \code{list},
\code{checkClass=FALSE} is preferred since there is only one class
in the resulting \code{list} elements. This approach is faster
especially for for large input lists, 10000 or more.
\item When \code{checkClass=FALSE} it assumes all entries can be
coerced to \code{character}, which is fastest, but does not preserve
factor levels due to R coersion methods used by \code{unlist()}.
}}

\item{useBioc}{\code{logical} indicating whether this function should try
to use \code{S4Vectors::unstrsplit()} when the Bioconductor package
\code{S4Vectors} is installed, otherwise it will use a less
efficient \code{mapply()} operation.}

\item{useLegacy}{\code{logical} indicating whether to enable to previous
legacy process used by \code{cPaste()}.}

\item{honorFactor}{\code{logical} passed to \code{mixedSorts()}, whether any
\code{factor} vector should be sorted in factor level order.
When \code{honorFactor=FALSE} then even \code{factor} vectors are sorted
as if they were \code{character} vectors, ignoring the factor levels.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are passed to \code{mixedOrder()} when
\code{doSort=TRUE}.}
}
\value{
\code{character} vector with the same names and in the same order
as the input list \code{x}.
}
\description{
Paste a list of vectors into a character vector, with values
delimited by default with a comma.
}
\details{
\itemize{
\item \code{cPaste()} concatenates vector values using a delimiter.
\item \code{cPasteS()} sorts each vector using \code{mixedSort()}.
\item \code{cPasteU()} applies \code{uniques()} to retain unique values per vector.
\item \code{cPasteSU()} applies \code{mixedSort()} and \code{uniques()}.
}

This function is essentially a wrapper for \code{S4Vectors::unstrsplit()}
except that it also optionally applies uniqueness to each vector
in the list, and sorts values in each vector using \code{mixedOrder()}.

The sorting and uniqueness is applied to the \code{unlist}ed vector of
values, which is substantially faster than any \code{apply} family function
equivalent. The uniqueness is performed by \code{uniques()}, which itself
will use \code{S4Vectors::unique()} if available.
}
\examples{
L1 <- list(CA=LETTERS[c(1:4,2,7,4,6)], B=letters[c(7:11,9,3)]);

cPaste(L1);
#               CA                 B
# "A,B,C,D,B,G,D,F"   "g,h,i,j,k,i,c"

cPaste(L1, doSort=TRUE);
#               CA                 B
# "A,B,B,C,D,D,F,G"   "c,g,h,i,i,j,k"

## The sort can be done with convenience function cPasteS()
cPasteS(L1);
#               CA                 B
# "A,B,B,C,D,D,F,G"   "c,g,h,i,i,j,k"

## Similarly, makeUnique=TRUE and cPasteU() are the same
cPaste(L1, makeUnique=TRUE);
cPasteU(L1);
#           CA             B
# "A,B,C,D,G,F" "g,h,i,j,k,c"

## Change the delimiter
cPasteSU(L1, sep="; ")
#                CA                  B
# "A; B; C; D; F; G" "c; g; h; i; j; k"

# test mix of factor and non-factor
L2 <- c(
   list(D=factor(letters[1:12],
      levels=letters[12:1])),
   L1);
L2;
cPasteSU(L2, keepFactors=TRUE);

# tricky example with mix of character and factor
# and factor levels are inconsistent
# end result: factor levels are defined in order they appear
L <- list(entryA=c("miR-112", "miR-12", "miR-112"),
   entryB=factor(c("A","B","A","B"),
      levels=c("B","A")),
   entryC=factor(c("C","A","B","B","C"),
      levels=c("A","B","C")),
   entryNULL=NULL)
L;
cPaste(L);
cPasteU(L);

# by default keepFactors=FALSE, which means factors are sorted as characters
cPasteS(L);
cPasteSU(L);
# keepFactors=TRUE will keep unique factor levels in the order they appear
# this is the same behavior as unlist(L[c(2,3)]) on a list of factors
cPasteSU(L, keepFactors=TRUE);
levels(unlist(L[c(2,3)]))

}
\seealso{
Other jam list functions: 
\code{\link{heads}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
