% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw.R
\docType{package}
\name{jackstraw}
\alias{jackstraw}
\alias{jackstraw-package}
\title{jackstraw: Statistical Inference for Unsupervised Learning}
\description{
Test for association between the observed data
	and their systematic patterns of variations.
	Systematic patterns may be captured by latent variables using principal component analysis (PCA), factor analysis (FA), and related methods. The jackstraw enables statistical testing for association between observed variables and latent variables, as captured by PCs or other estimates. Similarly, unsupervised clustering, such as K-means clustering, partition around medoids (PAM), and others, finds subpopulations among the observed variables. The jackstraw estimates statistical significance of cluster membership, including unsupervised evaluation of cell identities in single cell RNA-seq. P-values and posterior probabilities allows one to rigorously evaluate the strength of cluster membership assignments.
}
\details{
The jackstraw package provides a resampling strategy and testing scheme to estimate statistical significance
of association between the observed data and their latent variables. Depending on the data type and the analysis aim,
the latent variables may be estimated by principal component analysis, K-means clustering, and related algorithms.
The jackstraw methods learn over-fitting characteristics inherent in this circular analysis, where the observed data are used
to estimate the latent variables and to again test against the estimated latent variables.

The jackstraw tests enable us to identify the data features (i.e., variables or observations) that are
driving systematic variation, in a completely unsupervised manner. Using \link{jackstraw_pca}, we can
find statistically significant features with regard to the top \code{r} principal components.
Alternatively, \link{jackstraw_kmeans} can identify the data features that are statistically significant
members of the data-dependent clusters. Furthermore, this package includes more general algorithms such as
\link{jackstraw_subspace} for the dimension reduction techniques and \link{jackstraw_cluster} for the clustering algorithms.

Overall, it computes \code{m} p-values of association between the \code{m} data features and their corresponding latent variables.
From \code{m} p-values, \link{pip} computes posterior inclusion probabilities, that are useful for feature selection and visualization.
}
\references{
Chung and Storey (2015) Statistical significance of variables driving systematic variation in high-dimensional data. Bioinformatics, 31(4): 545-554 \url{http://bioinformatics.oxfordjournals.org/content/31/4/545}

Chung (2018) Statistical significance for cluster membership. biorxiv, doi:10.1101/248633 \url{https://www.biorxiv.org/content/early/2018/01/16/248633}
}
\seealso{
\link{jackstraw_pca} \link{jackstraw_subspace} \link{jackstraw_kmeans} \link{jackstraw_cluster}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
