% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZonalQ.R
\name{ZonalQ}
\alias{ZonalQ}
\title{Evaluation of quaternionic zonal polynomials}
\usage{
ZonalQ(x, lambda, algorithm = "DK")
}
\arguments{
\item{x}{numeric or complex vector or \link[gmp]{bigq} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{algorithm}{the algorithm used, either \code{"DK"} (Demmel-Koev)
or \code{"naive"}}
}
\value{
A numeric or complex scalar or a \code{bigq} rational number.
}
\description{
Evaluates a quaternionic (or symplectic) zonal polynomial.
}
\examples{
lambda <- c(2,2)
ZonalQ(c(3,1), lambda)
ZonalQ(c(gmp::as.bigq(3),gmp::as.bigq(1)), lambda)
##
x <- c(3,1)
ZonalQ(x, c(1,1)) + ZonalQ(x, 2) # sum(x)^2
ZonalQ(x, 3) + ZonalQ(x, c(2,1)) + ZonalQ(x, c(1,1,1)) # sum(x)^3
}
\references{
F. Li, Y. Xue. \emph{Zonal polynomials and hypergeometric
functions of quaternion matrix argument}.
Comm. Statist. Theory Methods, 38 (8), 1184-1206, 2009
}
\seealso{
\code{\link{ZonalQPol}}
}
