% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dm.setMutationModel}
\alias{dm.setMutationModel}
\title{Defines what mutation model is used for simulations}
\usage{
dm.setMutationModel(dm, mutation.model, base.frequencies, tstv.ratio, gtr.rates)
}
\arguments{
\item{dm}{The demographic model for which the mutation model will be set.}

\item{mutation.model}{The mutation model you want to use. Can be HKY, F84 or GTR.}

\item{base.frequencies}{The equilibrium frequencies of the four bases.
Must be a numeric vector of length four.
Order is A, C, G, T.}

\item{tstv.ratio}{The ratio of transitions to transversions. The default is
0.5, which means that all amino acid substitutions are
equally likely. In this case, the HKY model is identical to
the Felsenstein 81 model.}

\item{gtr.rates}{The rates for the amino acid substitutions. Must be a
numeric vector of length six. Order: A->C, A->G, A->T, C->G, C->T, G->T.}
}
\value{
The demographic model with the new mutation model.
}
\description{
As default, we simulate mutation using the Infinite Sites Model.
Using the function, you can change it either to the Hasegawa, Kishino and
Yano (HKY), to the Felsenstein and Churchill 96 (F84) or to the Generalised
time reversible (GTR) model. This requires that seq-gen is installed on our system.
}
\details{
The HKY and F84 models use the the arguments 'base.frequencies' and
'tstv.ratio'. The GTR model uses 'gtr.rates'.
}
\examples{
dm <- dm.createThetaTauModel(10:11, 10, 100)
dm <- dm.addOutgroup(dm, "2*tau")
dm.hky <- dm.setMutationModel(dm, "HKY", c(0.2, 0.2, 0.3, 0.3), 2)
dm.f81 <- dm.setMutationModel(dm, "F84", c(0.3, 0.2, 0.3, 0.2), 2)
dm.gtr <- dm.setMutationModel(dm, "GTR", gtr.rates=c(0.2, 0.2, 0.1, 0.1, 0.1, 0.2))
}

