% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dtsf}
\alias{dtsf}
\title{Splines data set}
\format{A data frame with 4,200 rows and 8 columns.
\describe{
  \item{x}{covariate}
  \item{z}{instrument}
  \item{f}{density}
  \item{p}{probability of treatment uptake}
  \item{ey1}{counterfactual outcome when a recipient of treatment}
  \item{ey0}{counterfactual outcome when not a recipient of treatment}
  \item{d}{indicator for treatment (d = 1) versus control (d = 0) group}
  \item{ey}{the observed outcome}
}}
\source{
Simulated.
}
\usage{
dtsf
}
\description{
A simulated population-level data set characterizing the effect of
a treatment on an outcome. The data includes a treatment indicator,
a single covariate, and a single covariate. The unobservable terms
generating the outcomes are generated according to the following
specifications:
y1 ~ beta0 + beta1 * x + uSpline(degree = 2,
                                knots  = c(0.3, 0.6),
                                intercept = FALSE)
}
\details{
y0 = x : uSpline(degree = 0,
                 knots  = c(0.2, 0.5, 0.8),
                 intercept = TRUE)
     + uSpline(degree = 1,
               knots  = c(0.4),
               intercept = TRUE)
     + beta3 * I(u ^ 2)

This data set is generated by the (non-exported) command
\code{gendist_splines()}.
}
\keyword{datasets}
