% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{check_resid}
\alias{check_resid}
\title{Inspect residuals of regression models.}
\usage{
check_resid(model, AR_start = NULL, split_pred = NULL, ask = TRUE,
  select = 1:4)
}
\arguments{
\item{model}{A regression model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}, or \code{lm},
\code{glm}, \code{lmer}, or \code{glmer}.}

\item{AR_start}{Defaults to NULL. 
Only use this when the model was run in an old versions of package 
\code{mgcv} and the function cannot retrieve the used AR.start values from 
the \code{model}. When an error is shown with newer versions of 
\code{mgcv}, please check the column provided as values of AR.start.
when using old versions of package \code{mgcv}.
Function will give error when it cannot find AR.start.}

\item{split_pred}{A names list indicating time series in the data.}

\item{ask}{Logical: whether or not to show the plots one by one. 
Defaults to TRUE. When set to FALSE, make sure to have specified 
sufficient rows and columns to show the X plots. Alternatively, 
use \code{select} to plot only specific plots.}

\item{select}{Vector or numeric value indicating which plots to return 
(see Notes). Defaults to 1:4 (all).}
}
\description{
Inspect residuals of regression models.
}
\section{Note}{

\itemize{
\item Plot 1: distribution of residuals with QQ norm plot.
\item Plot 2: distribution of residuals with density plot.
\item Plot 3: ACF plot of residuals. In case an AR1 model is included, 
the gray lines indicate standard residuals, and the thick black lines 
indicate AR1 corrected residuals. 
\item Plot 4 (optional): In case the \code{split_pred} predictors are 
specified an ACF plot averaged over the time series is produced. dashed 
lines indicate the maximum and minimum time series (w.r.t. lag 2), the 
solid lines the 25% and 75% quantiles (w.r.t. lag 2) and the bars the 
mean of all time series.
}
See the examples on how to specify a selection of these plots.
}
\examples{
data(simdat)

\dontrun{
# Add start event column:
simdat <- start_event(simdat, event=c("Subject", "Trial"))
head(simdat)

# bam model with AR1 model (toy example, not serious model):
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group), 
   data=simdat, rho=.5, AR.start=simdat$start.event)

# Warning, no time series specified:
check_resid(m1)

# Time series specified, results in a "standard" ACF plot, 
# treating all residuals as single time seriesand,
# and an ACF plot with the average ACF over time series:
check_resid(m1, split_pred=list(Subject=simdat$Subject, Trial=simdat$Trial))
# Note: residuals do not look very good.
# Alternative (results in the same, see help(acf_resid) ):
check_resid(m1, split_pred="AR.start")

# Define larger plot window (choose which line you need):
dev.new(width=8, height=8) # on windows or mac
quartz(,8,8)               # on mac
x11(width=8, height=8)     # on linux or mac

par(mfrow=c(2,2), cex=1.1)
check_resid(m1, split_pred="AR.start", ask=FALSE)
}

}
\author{
Jacolien van Rij
}
\seealso{
Other Model evaluation: \code{\link{diagnostics}},
  \code{\link{plot_modelfit}}
}

