% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/basic_plots.R
\name{plot_error}
\alias{plot_error}
\title{Utility function}
\usage{
plot_error(x, fit, se.fit, se.fit2 = NULL, shade = FALSE, f = 1,
  col = "black", border = NA, alpha = 0.25, ...)
}
\arguments{
\item{x}{Vector with values on x-axis.}

\item{fit}{Vector with values on y-axis.}

\item{se.fit}{Vector with standard error; or when \code{se.fit2}
is provided, \code{se.fit} specifies upper values confidence
interval.}

\item{se.fit2}{Optional: lower values confidence interval.}

\item{shade}{Logical: whether or not to produce shaded regions as
confidence bands.}

\item{f}{Factor for converting standard error in confidence intervals.
Defaults to 1. Use 1.96 for 95\% CI, and 2.58 for 99\% CI.}

\item{col}{Color for lines and confindence bands.}

\item{border}{A number, indicating the linewidth of the border around
shaded area. No border with value NA (default). Only applies when
\code{shade=TRUE}.}

\item{alpha}{Transparency of shaded area. Number between 0
(completely transparent) and 1 (not transparent).}

\item{...}{Optional arguments for the lines. See \code{\link{par}}.}
}
\description{
Plot line with confidence intervals.
}
\examples{
data(simdat)

# Use aggregate to calculate mean and standard deviation per timestamp:
avg <- aggregate(simdat$Y, by=list(Time=simdat$Time),
    function(x){c(mean=mean(x), sd=sd(x))})
head(avg)
# Note that column x has two values in each row:
head(avg$x)
head(avg$x[,1])

# Plot line and standard deviation:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'])
# Change layout:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'],
   shade=TRUE, lty=3, lwd=3)

# Show difference with 0:
x <- find_difference(avg$x[,'mean'], avg$x[,'sd'], xVals=avg$Time)
# Add arrows:
abline(v=c(x$start, x$end), lty=3, col='red')
arrows(x0=x$start, x1=x$end, y0=-5, y1=-5, code=3, length=.1, col='red')

# Use of se.fit2:
avg$cu <- avg$x[,'mean'] + avg$x[,'sd']
avg$cl <- avg$x[,'mean'] - avg$x[,'sd']
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], se.fit=avg$cu, se.fit2=avg$cl, col='red')
# Change layout:
emptyPlot(range(avg$Time), c(-20,20), h0=0)
plot_error(avg$Time, avg$x[,'mean'], avg$x[,'sd'],
   shade=TRUE, lty=3, lwd=3)
}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions for plotting: \code{\link{addInterval}};
  \code{\link{alphaPalette}}; \code{\link{alpha}};
  \code{\link{color_contour}}; \code{\link{dotplot_error}};
  \code{\link{emptyPlot}}; \code{\link{errorBars}};
  \code{\link{fadeRug}}; \code{\link{fill_area}};
  \code{\link{find_difference}}; \code{\link{getCoords}};
  \code{\link{getFigCoords}}; \code{\link{gradientLegend}};
  \code{\link{horiz_error}}
}

