% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoread.R
\name{iso_register_dual_inlet_file_reader}
\alias{iso_register_dual_inlet_file_reader}
\alias{iso_register_continuous_flow_file_reader}
\alias{iso_register_scan_file_reader}
\title{Register file readers}
\usage{
iso_register_dual_inlet_file_reader(
  extension,
  func,
  description = NA_character_,
  software = NA_character_,
  cacheable = TRUE,
  post_read_check = TRUE,
  overwrite = FALSE,
  env = find_func(func)
)

iso_register_continuous_flow_file_reader(
  extension,
  func,
  description = NA_character_,
  software = NA_character_,
  cacheable = TRUE,
  post_read_check = TRUE,
  overwrite = FALSE,
  env = find_func(func)
)

iso_register_scan_file_reader(
  extension,
  func,
  description = NA_character_,
  software = NA_character_,
  cacheable = TRUE,
  post_read_check = TRUE,
  overwrite = FALSE,
  env = find_func(func)
)
}
\arguments{
\item{extension}{the file extension (e.g. \code{.dxf}) of the data file. Must be unique otherwise different files can not automatically be matched with the appropriate file reader based on their extension.}

\item{func}{the name of the function that should be used a filter reader. All file reader functions must accept a data structure argument as the first argument and return the same data structure with added data.}

\item{description}{what is this file type about?}

\item{software}{what is the software program that creates this file type?}

\item{cacheable}{whether this file type is cacheable. If \code{TRUE} (the default), user requests to cache the file will be honored. If \code{FALSE}, this file type will never be cached no matter what the user requests.}

\item{post_read_check}{whether isoreader should conduct a data integrity check after reading the file. Should always be \code{TRUE} unless there is independent data integrity checking already taking place inside the reader.}

\item{overwrite}{whether to overwrite an existing file reader for the same extension}

\item{env}{the environment where to find the function, by default this will be determined automatically and will throw an error if there is any ambiguity (e.g. the same function name in multiple packages) in which case it should be set manually}
}
\description{
Register file extensions and reader functions for different data files. Isoreader automatically registers all built-in file readers so this function is usually only needed when registering additional readers provided for testing purposes from outside of the isoreader package. Note that file extensions are case-insensitive, i.e. a reader for \code{.ext} will also recognize \code{.Ext} and \code{.EXT}
}
\details{
\code{iso_register_dual_inlet_file_reader}: use this function to register file readers for dual inlet files.

\code{iso_register_continuous_flow_file_reader}: use this function to register file readers for continuous flow files.

\code{iso_register_scan_file_reader}: use this function to register file readers for scan files.
}
\seealso{
Other file_types: 
\code{\link{iso_get_supported_file_types}()}

Other file_types: 
\code{\link{iso_get_supported_file_types}()}

Other file_types: 
\code{\link{iso_get_supported_file_types}()}
}
\concept{file_types}
