% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quartz.R
\name{d17O_qz}
\alias{d17O_qz}
\title{Triple oxygen isotope values of quartz}
\usage{
d17O_qz(temp, d18O_H2O_VSMOW, D17O_H2O = 0, lambda = 0.528)
}
\arguments{
\item{temp}{Quartz growth temperature (°C).}

\item{d18O_H2O_VSMOW}{Water d18O value expressed on the VSMOW scale (‰).}

\item{D17O_H2O}{D17O value of ambient water calculated using
a lambda of \code{0.528}. Default \code{0}.}

\item{lambda}{Triple oxygen isotope reference slope. Default \code{0.528}.}
}
\value{
Returns a data frame:
\enumerate{
\item d18O value of the quartz expressed on the VSMOW scale (‰).
\item d17O value of the quartz expressed on the VSMOW scale (‰).
\item D17O value of the quartz expressed on the VSMOW scale (‰).
}
}
\description{
\code{d17O_qz()} calculates the equilibrium d18O, d17O, and D17O values of
quartz grown at a given temperature.
}
\details{
\deqn{\theta_{A/B} = \frac{\alpha^{17}_{A/B}}{\alpha^{18}_{A/B}}}

\deqn{ \delta'^{17}O_{H2O,VSMOW} =
\beta \times \delta'^{18}O_{H2O,VSMOW} + \gamma
\textrm{ , where } \beta=0.528 \textrm{ and } \gamma = 0 }

\deqn{\Delta^{17}O_{SiO2,VSMOW} = \delta'^{17}O_{SiO2,VSMOW} -
\lambda \times \delta'^{18}O_{SiO2,VSMOW} }

\strong{NOTE:}

\deqn{\theta_{quartz/water} = -\frac{1.85}{T} + 0.5305}

\deqn{\alpha^{18}_{quartz/water} =
e^{(\frac{4280}{T^{2}} - \frac{3.5}{T})}}
}
\examples{
d17O_qz(temp = 10, d18O_H2O_VSMOW = 0) # Returns the data frame (length = 3)
d17O_qz(temp = 10, d18O_H2O_VSMOW = 0)[, 3] # Returns the D17O value

}
\references{
Sharp, Z.D., Gibbons, J.A., Maltsev, O., Atudorei, V., Pack, A.,
Sengupta, S., Shock, E.L. and Knauth, L.P. (2016).
A calibration of the triple oxygen isotope fractionation in the
SiO2-H2O system and applications to natural samples.
Geochimica et Cosmochimica Acta, 186, 105-119.
\doi{10.1016/j.gca.2016.04.047}
}
\concept{quartz}
