% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schoenersD.R
\name{schoenersD}
\alias{schoenersD}
\title{Calculates Schoener's D-value between two RasterLayers.}
\usage{
schoenersD(rast1, rast2)
}
\arguments{
\item{rast1}{Input RasterLayer}

\item{rast2}{Input RasterLayer 2}
}
\description{
RasterLayers must have identical resolutions and extents.
}
\details{
Calculates similarity value of two RasterLayers using Schoener's D-metric.
}
\examples{
# Generate example probability surfaces.
myiso <- raster::rasterFromXYZ(isoscape)
myiso_sd <- raster::rasterFromXYZ(isoscape_sd)
df <- data.frame(
        ID = c(-100, -80, -50),
        isotopeValue = c(-100, -80, -50),
        SD_indv = rep(5, 3)
        )
assignmentModels <- isotopeAssignmentModel(
        ID = df$ID,
        isotopeValue = df$isotopeValue,
        SD_indv = df$SD_indv,
        precip_raster = myiso,
        precip_SD_raster = myiso_sd,
        nClusters = FALSE
        )

# Calculate Schoener's D-metric of spatial similarity between two of the
# example probability surfaces.
schoenersD(assignmentModels[[1]], assignmentModels[[2]])
## 0.969156

}
