% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_islasso.R
\name{predict.islasso}
\alias{predict.islasso}
\title{Prediction Method for islasso Objects}
\usage{
\method{predict}{islasso}(
  object,
  newdata = NULL,
  type = c("link", "response", "coefficients", "class", "terms"),
  se.fit = FALSE,
  ci = NULL,
  type.ci = c("wald", "score"),
  level = 0.95,
  terms = NULL,
  na.action = na.pass,
  ...
)
}
\arguments{
\item{object}{A fitted model of class \code{"islasso"}.}

\item{newdata}{Optional data frame containing predictors for prediction. If omitted, the fitted model matrix is used.}

\item{type}{Character. Specifies the prediction scale:
\itemize{
  \item \code{"link"} (default): linear predictor scale;
  \item \code{"response"}: original response scale;
  \item \code{"coefficients"}: estimated coefficients;
  \item \code{"class"}: predicted class (only for \code{binomial()} family);
  \item \code{"terms"}: contribution of each term to the linear predictor.
}}

\item{se.fit}{Logical. Whether to compute standard errors/confidence intervals.}

\item{ci}{Optional. Precomputed matrix of confidence intervals (2 columns).}

\item{type.ci}{Type of interval. Only \code{"wald"} is implemented.}

\item{level}{Confidence level for intervals. Default is \code{0.95}.}

\item{terms}{If \code{type = "terms"}, optionally specify which terms to extract.}

\item{na.action}{Function to handle missing values in \code{newdata}. Default: \code{na.pass}.}

\item{...}{Additional arguments passed to downstream methods.}
}
\value{
A numeric vector, matrix, or list depending on \code{type}.
}
\description{
Computes predictions from a fitted \code{\link{islasso}} model object. Multiple output types supported, including response scale, linear predictor, and coefficient values.
}
\examples{
set.seed(1)
n <- 100; p <- 100
beta <- c(runif(20, -3, 3), rep(0, p - 20))
sim <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
fit <- islasso(y ~ ., data = sim$data, family = gaussian(), lambda = 2)
predict(fit, type = "response")

}
\seealso{
\code{\link{islasso}}, \code{\link{summary.islasso}}, \code{\link{logLik.islasso}}, \code{\link{residuals.islasso}}, \code{\link{deviance.islasso}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
