% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psRace.R
\name{psRace}
\alias{psRace}
\title{Postselection race}
\usage{
psRace(
  iraceResults,
  max_experiments,
  conf_ids = NULL,
  iteration_elites = FALSE
)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}

\item{max_experiments}{\code{numeric(1)}\cr Number of experiments for the
post-selection race. If it is equal to or smaller than 1, then it is a
fraction of the total budget given by
\code{iraceResults$scenario$maxExperiments} or \code{iraceResults$scenario$maxTime / iraceResults$state$boundEstimate}.}

\item{conf_ids}{IDs of the configurations in iraceResults$allConfigurations to be used for ablation.
If NULL, the \code{iteration_best} argument will be to decide.}

\item{iteration_elites}{If TRUE, only select the best configuration of each iteration.
If FALSE, select from all elite configurations of all iterations. \code{max_experiments}}
}
\value{
If iraceLogFile is NULL, it returns a list with the following elements:
\describe{
\item{configurations}{Configurations used in the race.}
\item{instances}{A matrix with the instances used in the experiments. First column has the
instances ids from iraceResults$scenario$instances, second column the seed assigned to the instance.}
\item{maxExperiments}{Maximum number of experiments set for the race.}
\item{experiments}{A matrix with the results of the experiments (columns are configurations, rows are instances).}
\item{elites}{Best configurations found in the experiments.}
}
If \code{iraceLogFile} is provided this list object will be saved in \code{iraceResults$psrace_log}.
}
\description{
\code{psRace} performs a postselection race of a set of configurations.
}
\examples{
\donttest{
  logfile <- system.file(package="irace", "exdata", "sann.rda")
  # Execute the postselection after the execution of irace. Use 10\% of the total budget.
  psRace(logfile, max_experiments=0.1)
}
}
\author{
Leslie Pérez Cáceres and Manuel López-Ibáñez
}
