% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{separate.ir}
\alias{separate.ir}
\title{Separate a character column in an \code{ir} object into multiple columns with a regular expression or numeric locations}
\source{
\code{\link[tidyr:separate]{tidyr::separate()}}
}
\usage{
separate.ir(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)
}
\arguments{
\item{data}{An object of class \code{ir}.}

\item{col}{Column name or position. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

This argument is passed by expression and supports
\link[rlang:nse-force]{quasiquotation} (you can unquote column
names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{sep}{Separator between columns.

If character, \code{sep} is interpreted as a regular expression. The default
value is a regular expression that matches any sequence of
non-alphanumeric values.

If numeric, \code{sep} is interpreted as character positions to split at. Positive
values start at 1 at the far-left of the string; negative value start at -1 at
the far-right of the string. The length of \code{sep} should be one less than
\code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link[=type.convert]{type.convert()}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.

NB: this will cause string \code{"NA"}s to be converted to \code{NA}s.}

\item{extra}{If \code{sep} is a character vector, this controls what
happens when there are too many pieces. There are three valid options:
\itemize{
\item "warn" (the default): emit a warning and drop extra values.
\item "drop": drop any extra values without a warning.
\item "merge": only splits at most \code{length(into)} times
}}

\item{fill}{If \code{sep} is a character vector, this controls what
happens when there are not enough pieces. There are three valid options:
\itemize{
\item "warn" (the default): emit a warning and fill from the right
\item "right": fill with missing values on the right
\item "left": fill with missing values on the left
}}

\item{...}{Additional arguments passed on to methods.}
}
\value{
\code{.data} with separated columns. If the \code{spectra} column is
dropped or invalidated (see \code{\link[=ir_new_ir]{ir_new_ir()}}), the \code{ir} class is dropped, else
the object is of class \code{ir}.
}
\description{
Separate a character column in an \code{ir} object into multiple columns with a regular expression or numeric locations
}
\examples{
## separate
ir_sample_data \%>\%
  tidyr::separate(
    col = "id_sample",  c("a", "b", "c")
  )


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
