% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{range}
\alias{range}
\alias{range.ir}
\alias{min.ir}
\alias{max.ir}
\alias{median.ir}
\title{Get the minima/maxima/range/median of x axis values or intensity values of infrared spectra}
\usage{
\method{range}{ir}(
  x,
  ...,
  na.rm = FALSE,
  .dimension = "y",
  .col_names = c("y_min", "y_max")
)

\method{min}{ir}(x, ..., na.rm = FALSE, .dimension = "y", .col_name = "y_min")

\method{max}{ir}(x, ..., na.rm = FALSE, .dimension = "y", .col_name = "y_max")

\method{median}{ir}(x, na.rm = FALSE, ..., .dimension = "y", .col_name = "y_median")
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{...}{Further arguments, ignored.}

\item{na.rm}{A logical value. See \code{\link[=max]{max()}}.}

\item{.dimension}{A character value. Must be one of the following:
\describe{
\item{"x"}{In this case, the minimum/maximum/range/median of x axis values
of the spectra in \code{x} are extracted.}
\item{"y"}{In this case, the minimum/maximum/range/median of intensity
values of the spectra in \code{x} are extracted.}
}}

\item{.col_names}{A character vector of length 2 representing the names of the
columns in which to store the extracted values. The first element is the name
for the column with minima values, the second the name for the column with
maxima values.}

\item{.col_name}{A character value representing the name of the column in
which to store the extracted values.}
}
\value{
\code{x} with the extracted values.
}
\description{
\code{range.ir} extracts the range of x axis values (e.g. wavenumbers) or
intensity values of infrared spectra.

\code{min.ir} extracts the minimum x axis value (e.g. wavenumber) or
intensity value of infrared spectra.

\code{max.ir} extracts the maximum x axis value (e.g. wavenumber) or
intensity value of infrared spectra.

\code{median.ir} extracts the median x axis value (e.g. wavenumber) or
intensity value of infrared spectra.
}
\examples{
# range of intensity values
x1 <-
   ir::ir_sample_data \%>\%
   range(.dimension = "y")

# minimum intensity values
x1 <-
   ir::ir_sample_data \%>\%
   min(.dimension = "y")

# maximum intensity values
x1 <-
   ir::ir_sample_data \%>\%
   max(.dimension = "y")

# median intensity values
x1 <-
   ir::ir_sample_data \%>\%
   stats::median(.dimension = "y")

}
