% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliscore.R
\name{aliscore}
\alias{aliscore}
\title{Masking of Sequence Alignments with ALISCORE}
\usage{
aliscore(x, gaps = "5state", w = 6, r, t, l, s, o, exec)
}
\arguments{
\item{x}{DNA sequences of class \code{DNAbin}.}

\item{gaps}{A vector of mode \code{"character"} indicating how gaps shall be
treated: as \code{"5state"} or as \code{"ambiguous"}.}

\item{w}{An integer giving the size of the sliding window.}

\item{r}{An integer giving the number of random pairwise sequence
comparisons; defaults to \code{4 * N}.}

\item{t}{\emph{Not yet implemented}.}

\item{l}{\emph{Not yet implemented}.}

\item{s}{\emph{Not yet implemented}.}

\item{o}{A vector of mode \code{"character"} containing outgroup taxon names.}

\item{exec}{A character string, giving the path to the Aliscore script.}
}
\value{
A \code{matrix} of class \code{"DNAbin"}.
}
\description{
Provides a interface to \bold{Aliscore}, in order to remove
  problematic regions of a DNA sequence alignment.
}
\note{
This function was developed with ALISCORE version 2.
}
\examples{
data(ips.28S)
\dontrun{aliscore(ips.28S)}
}
\references{
Misof, B. and K. Misof. 2009. A Monte Carlo approach successfully identifies
randomness in multiple sequence alignments: a more objective means of data
exclusion. \emph{Syst. Biol.} \bold{58}: 21--34.

Kueck, P., K. Meusemann, J. Dambach, B. Thormann, B.M. von Reumont, J.W.
Waegele and B. Misof. 2010. Parametric and non-parametric masking of
randomness in sequence alignments can be improved and leads to better
resolved trees. \emph{Frontiers in Zoology} \bold{7}: 10.

\bold{Aliscore website}: \url{https://bonn.leibniz-lib.de/en/research/research-centres-and-groups/aliscore}
}
\seealso{
\code{\link{mafft}} and \code{\link{prank}} for multiple sequence
  alignment; \code{\link{gblocks}} for another alignment masking algorithm.
}
