
<!-- README.md is generated from README.Rmd. Please edit that file -->

# `ipmisc`: Miscellaneous Functions for Data Cleaning and Analysis

[![CRAN\_Release\_Badge](https://www.r-pkg.org/badges/version-ago/ipmisc)](https://CRAN.R-project.org/package=ipmisc)
[![Daily downloads
badge](https://cranlogs.r-pkg.org/badges/last-day/ipmisc?color=blue)](https://CRAN.R-project.org/package=ipmisc)
[![Weekly downloads
badge](https://cranlogs.r-pkg.org/badges/last-week/ipmisc?color=blue)](https://CRAN.R-project.org/package=ipmisc)
[![Monthly downloads
badge](https://cranlogs.r-pkg.org/badges/last-month/ipmisc?color=blue)](https://CRAN.R-project.org/package=ipmisc)
[![Total downloads
badge](https://cranlogs.r-pkg.org/badges/grand-total/ipmisc?color=blue)](https://CRAN.R-project.org/package=ipmisc)
[![Travis Build
Status](https://travis-ci.org/IndrajeetPatil/ipmisc.svg?branch=master)](https://travis-ci.org/IndrajeetPatil/ipmisc)
[![AppVeyor Build
Status](https://ci.appveyor.com/api/projects/status/github/IndrajeetPatil/ipmisc?branch=master&svg=true)](https://ci.appveyor.com/project/IndrajeetPatil/ipmisc)
[![Licence](https://img.shields.io/badge/licence-GPL--3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)
[![Project Status: Active - The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![lifecycle](https://img.shields.io/badge/lifecycle-maturing-blue.svg)](https://www.tidyverse.org/lifecycle/)
[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.6.0-6666ff.svg)](https://cran.r-project.org/)
[![Coverage
Status](https://img.shields.io/codecov/c/github/IndrajeetPatil/ipmisc/master.svg)](https://codecov.io/github/IndrajeetPatil/ipmisc?branch=master)
[![Coverage
Status](https://coveralls.io/repos/github/IndrajeetPatil/ipmisc/badge.svg?branch=master)](https://coveralls.io/github/IndrajeetPatil/ipmisc?branch=master)
[![status](https://tinyverse.netlify.com/badge/ipmisc)](https://CRAN.R-project.org/package=ipmisc)

# Introduction

The `ipmisc` provides functions for data cleaning and formatting. These
functions form data cleaning backend for the following packages:

-   `ggstatsplot`: <https://indrajeetpatil.github.io/ggstatsplot/>

-   `statsExpressions`:
    <https://indrajeetpatil.github.io/statsExpressions/>

-   `pairwiseComparisons`:
    <https://indrajeetpatil.github.io/pairwiseComparisons/>

-   `groupedstats`: <https://indrajeetpatil.github.io/groupedstats/>

-   `tidyBF`: <https://indrajeetpatil.github.io/tidyBF/>

-   `broomExtra`: <https://indrajeetpatil.github.io/broomExtra/>

# Installation

You can install the `CRAN` version of `ipmisc`:

``` r
install.packages("ipmisc")
```

And the development version from `GitHub` with:

``` r
# install.packages("remotes")
remotes::install_github("IndrajeetPatil/ipmisc")
```

# Functions

To see all available functionality, see the documentation provided here:
<https://indrajeetpatil.github.io/ipmisc/reference/index.html>

# Code of Conduct

Please note that the `ipmisc` project is released with a [Contributor
Code of
Conduct](https://github.com/IndrajeetPatil/ipmisc/blob/master/CODE_OF_CONDUCT.md).
By contributing to this project, you agree to abide by its terms.
