% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value_formatter.R
\name{p_value_formatter}
\alias{p_value_formatter}
\title{Format \emph{p}-values for creating labels from them for graphics}
\usage{
p_value_formatter(data, k = 3L, ...)
}
\arguments{
\item{data}{Data frame from which variables specified are preferentially to
be taken.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 3L}).}

\item{...}{Currently ignored.}
}
\description{
Format \emph{p}-values for creating labels from them for graphics
}
\examples{
# preparing a new dataframe
df <-
  cbind.data.frame(
    x = 1:5,
    y = 1,
    p.value = c(0.1, 0.5, 0.00001, 0.05, 0.01)
  )

# prepare label
p_value_formatter(data = df, k = 4L)
}
