% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pathdistGen.R
\name{pathdistGen}
\alias{pathdistGen}
\title{Generate a stack of path distance raster objects}
\usage{
pathdistGen(spdf, costras, range, yearmon = "default")
}
\arguments{
\item{spdf}{SpatialPointsDataFrame object}

\item{costras}{RasterLayer cost raster}

\item{range}{numeric. Range of interpolation neighborhood}

\item{yearmon}{character. String specifying the name of the spdf}
}
\value{
RasterStack object of path distances
}
\description{
Generate a stack of path distance raster objects
}
\examples{
spdf<-data.frame(rnorm(2))
xy<-data.frame(x=c(4,2),y=c(8,4))
coordinates(spdf)<-xy

m<-matrix(NA,10,10)
costras<-raster(m,xmn=0,xmx=ncol(m),ymn=0,ymx=nrow(m))
costras[]<-runif(ncell(costras),min=1,max=10)
#introduce spatial gradient
for(i in 1:nrow(costras)){
costras[i,]<-costras[i,]+i
costras[,i]<-costras[,i]+i
}

rstack<-pathdistGen(spdf,costras,100)
}
\author{
Joseph Stachelek
}

