% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conforming_vector_create.R
\name{conforming_vector_create}
\alias{conforming_vector_create}
\title{Create an empty conforming vector}
\usage{
conforming_vector_create(dat)
}
\arguments{
\item{dat}{A use table, Leontieff-matrix, Leontieff-inverse, a coefficient matrix 
or other named matrix / vector.}
}
\description{
This helper function creates you a named vector that conforms your
analytical objects, such as the use table, the Leontieff-matrix, 
etc. With 60x60 matrixes it is easy to make mistakes with manual 
definition. The empty effects vector can be used in .csv format
as a sample to import scenearios from a spreadsheet application.
}
\examples{
de_use <- use_table_get ( source = "germany_1990", geo = "DE",
                         year = 1990, unit = "MIO_EUR", 
                         households = FALSE, labelling = "iotables")

conforming_vector_create (de_use)
}
