% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identification_test.R
\name{ChenFang2019BetaRankTest}
\alias{ChenFang2019BetaRankTest}
\title{Compute the Chen Fang 2019 beta rank test}
\usage{
ChenFang2019BetaRankTest(
  returns,
  factors,
  n_bootstrap = 500,
  target_level_kp2006_rank_test = 0.05,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{\verb{n_observations x n_returns}-dimensional matrix of test asset
excess returns.}

\item{factors}{\verb{n_observations x n_factors}-dimensional matrix of risk
factors.}

\item{n_bootstrap}{numeric integer indicating the number of bootstrap
samples used to compute the Chen fang 2019 test. Default is \code{500}.}

\item{target_level_kp2006_rank_test}{numeric level of the Kleibergen Paap
2006 rank test. If it is strictly grater than zero, then the iterative
Kleibergen Paap 2006 rank test at \code{level = target_level_kp2006_rank_test / n_factors} is used to compute an initial estimator of the rank of the factor
loadings in the Chen Fang 2019 rank test. Otherwise, the initial rank
estimator is taken to be the number of singular values above
\code{n_observations^(-1/4)}. Default is \code{0.05} (as correction for multiple
testing).}

\item{check_arguments}{boolean \code{TRUE} if you want to check function arguments;
\code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
a list containing the Chen fang 2019 rank statistic and the
corresponding p-value.
}
\description{
Computes the Chen fang 2019 rank statistic and p-value of the
null that the matrix of regression loadings of test asset excess returns on
risk factors has reduced rank. If \code{target_level_kp2006_rank_test > 0},
it uses the iterative Kleibergen Paap 2006 rank test to estimate the initial
rank, with \code{level = target_level_kp2006_rank_test / n_factors}. If
\code{target_level_kp2006_rank_test <= 0}, the initial rank estimator is taken to
be the number of singular values above \code{n_observations^(-1/4)}. It assumes
n_factors < n_returns.
}
\examples{
# import package data on 15 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# compute the model identification test
hj_test = ChenFang2019BetaRankTest(returns, factors)

}
