% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarpuy_traits.R
\name{tarpuy_traits}
\alias{tarpuy_traits}
\title{Field book traits}
\usage{
tarpuy_traits(fieldbook = NULL, last_factor = NULL, traits = NULL)
}
\arguments{
\item{fieldbook}{Experiment field book [dataframe].}

\item{last_factor}{Last factor in the field book [string: colnames]}

\item{traits}{Traits information [dataframe or list].}
}
\value{
list
}
\description{
Function to export field book and traits for be used in field book app.
}
\details{
For the traits parameters you can used shown in the field Book app
}
\examples{

library(inti)

fieldbook <- inti::potato

traits <- list(
  list(variable = "altura de planta"
       , abbreviation = "altp"
       , format = "numeric"
       , when = "30, 40, 50"
       , samples = 3
       , units = "cm"
       , details = NA
       , minimum = 0
       , maximum = 100
       )
  , list(variable = "severidad"
         , abbreviation = "svr"
         , format = "categorical"
         , when = "30, 40, 50"
         , samples = 1
         , units = "scale"
         , details = NA
         , categories = "1, 3, 5, 7, 9"
  )
  ,  list(variable = "foto"
          , abbreviation = "foto"
          , format = "photo"
          , when = "hrv, pshrv"
          , samples = 1
          , units = "image"
          , details = NA
  )
  ,  list(variable = "germinacion"
          , abbreviation = "ger"
          , format = "boolean"
          , when = "30, 40, 50"
          , samples = 1
          , units = "logical"
          , details = NA
  )
) 

fbapp <- tarpuy_traits(fieldbook, last_factor = "bloque", traits)

\dontrun{ 

library(inti)
library(gsheet)

url_fb <- paste0("https://docs.google.com/spreadsheets/d/"
       , "17coCIWBIzQSUAvzC6rkfjPj7i1Ob1dcx-L1tAsBUO5s/edit#gid=731057423")
       
fb <- gsheet2tbl(url_fb) 

url_ds <- paste0("https://docs.google.com/spreadsheets/d/"
       , "17coCIWBIzQSUAvzC6rkfjPj7i1Ob1dcx-L1tAsBUO5s/edit#gid=470588086")
       
ds <- gsheet2tbl(url_ds) 

fb <- ds \%>\% tarpuy_design()

url_trt <- paste0("https://docs.google.com/spreadsheets/d/"
       , "17coCIWBIzQSUAvzC6rkfjPj7i1Ob1dcx-L1tAsBUO5s/edit#gid=470588086")
       
traits <- gsheet2tbl(url_trt) 

fbapp <- tarpuy_traits(fb, last_factor = "cols", traits)

dsg <- fbapp[[1]]

}

}
