% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yupana_export_smr.R
\name{yupana_export_smr}
\alias{yupana_export_smr}
\title{Graph options to export}
\usage{
yupana_export_smr(
  data,
  response,
  comparison,
  model,
  test_comp = NA,
  type = NA,
  xlab = NA,
  ylab = NA,
  glab = NA,
  ylimits = NA,
  xrotation = c(0, 0.5, 0.5),
  xtext = NA,
  gtext = NA,
  legend = "top",
  sig = NA,
  error = NA,
  color = TRUE,
  opt = NA,
  dimension = c(20, 10, 100),
  sig_level = NA
)
}
\arguments{
\item{data}{Fieldbook data.}

\item{response}{Model used for the experimental design.}

\item{comparison}{Factor to compare}

\item{model}{Model used in the analysis}

\item{test_comp}{Type of test comparison}

\item{type}{Plot type}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{limits of the y axis}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in group}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{error}{Show the error bar ("ste" or "std").}

\item{color}{colored figure (TRUE), otherwise black & white (FALSE)}

\item{opt}{Add news layer to the plot}

\item{dimension}{Dimension of graphs}

\item{sig_level}{Level of significance for the test}
}
\value{
data frame
}
\description{
Function to export the graph options and model parameters
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/"
              , "edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

mc <- mean_comparison(data = fb
                      , response = "hi"
                      , model_factors = "geno*treat"
                      , comparison = c("geno", "treat")
                      )
mc$comparison

}

}
