% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterferenceTable.R
\name{InterferenceTable}
\alias{InterferenceTable}
\title{Computes the Interference Table}
\usage{
InterferenceTable(spectr = seq(360, 830, by = 5), birefVect = seq(2e-04,
  0.1, by = 5e-04), thickVect = seq(0.01, 50, length.out = 50))
}
\arguments{
\item{spectr}{A vector of wavelengths (in nanometers).}

\item{birefVect}{A vector of birefringence values.}

\item{thickVect}{A vector of thickness values (in micrometers).}
}
\value{
A data frame with 6 variables
(columns) named thickness, biref, R, G, B and retardation
}
\description{
\code{InterferenceTable} is the package workhorse. It computes retardations
for specified sets of wavelength, birefringence and thickness values
and turns the corresponding transmission matrix into color coordinates
in the sRGB colorspace. For now the colorimetric setting is nested into
the function. It makes use of D65 illuminant and CIE 1931 2 degrees Color 
Matching Functions in order to reproduce Sorensen's paper setting. 
Computations may be slow for high resolutions.
}
\examples{
\dontrun{
test.IC<- InterferenceTable(spectr=seq(360,830,by=5),
birefVect=seq(0.0002,0.1,by=0.0005),thickVect=seq(0.01,50,length.out=50))
}
}
\references{
Sorensen, B.E. (2013) A revised Michel-Levy interference colour chart based
on first-principles calculations. Eur. J. Mineral., 2013, 25, 5-10.
DOI:10.1127/0935-1221/2013/0025-2252
}
\seealso{
\code{\link[colorspace]{sRGB}},
\code{\link[colorSpec]{D65}},
\code{\link[colorSpec]{xyz1931}},
\pkg{colorSpec}
}
\author{
Olivier Eterradossi, \email{olivier.eterradossi@mines-ales.fr}
}
