% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_slopes.R
\name{sim_slopes}
\alias{sim_slopes}
\title{Perform a simple slopes analysis.}
\usage{
sim_slopes(
  model,
  pred,
  modx,
  mod2 = NULL,
  modx.values = NULL,
  mod2.values = NULL,
  centered = "all",
  data = NULL,
  cond.int = FALSE,
  johnson_neyman = TRUE,
  jnplot = FALSE,
  jnalpha = 0.05,
  robust = FALSE,
  digits = getOption("jtools-digits", default = 2),
  pvals = TRUE,
  confint = FALSE,
  ci.width = 0.95,
  cluster = NULL,
  modx.labels = NULL,
  mod2.labels = NULL,
  v.cov = NULL,
  v.cov.args = NULL,
  ...
)
}
\arguments{
\item{model}{A regression model. The function is tested with \code{lm},
\code{glm}, \code{\link[survey]{svyglm}}, \code{\link[lme4]{merMod}},
\code{\link[quantreg]{rq}}, \code{\link[brms]{brmsfit}},
\code{stanreg} models.
Models from other classes may work as well but are not officially
supported. The model should include the interaction of interest.}

\item{pred}{The name of the predictor variable involved
in the interaction. This can be a bare name or string. Note that it
is evaluated using \code{rlang}, so programmers can use the \verb{!!} syntax
to pass variables instead of the verbatim names.}

\item{modx}{The name of the moderator variable involved
in the interaction. This can be a bare name or string. The same
\code{rlang} proviso applies as with \code{pred}.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction. This can be a bare name or string.
The same \code{rlang} proviso applies as with \code{pred}.}

\item{modx.values}{For which values of the moderator should lines be
plotted? There are two basic options:
\itemize{
\item A vector of values (e.g., \code{c(1, 2, 3)})
\item A single argument asking to calculate a set of values. See details
below.
}

Default is \code{NULL}. If \code{NULL} (or \code{mean-plus-minus}),
then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If \code{"plus-minus"}, plots lines when the moderator is at
+/- 1 standard deviation without the mean. You may also choose \code{"terciles"}
to split the data into equally-sized groups and choose the point at the
mean of each of those groups.

If the moderator is a factor variable and \code{modx.values} is
\code{NULL}, each level of the factor is included. You may specify
any subset of the factor levels (e.g., \code{c("Level 1", "Level 3")}) as long
as there is more than 1. The levels will be plotted in the order you
provide them, so this can be used to reorder levels as well.}

\item{mod2.values}{For which values of the second moderator should the plot
be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modx.values}.}

\item{centered}{A vector of quoted variable names that are to be
mean-centered. If \code{"all"}, all non-focal predictors as well as
the \code{pred} variable are centered. You
may instead pass a character vector of variables to center. User can
also use "none" to base all predictions on variables set at 0.
The response variable, \code{modx}, and \code{mod2} variables are never
centered.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{cond.int}{Should conditional intercepts be printed in addition to the
slopes? Default is \code{FALSE}.}

\item{johnson_neyman}{Should the Johnson-Neyman interval be calculated?
Default is \code{TRUE}. This can be performed separately with
\code{\link{johnson_neyman}}.}

\item{jnplot}{Should the Johnson-Neyman interval be plotted as well? Default
is \code{FALSE}.}

\item{jnalpha}{What should the alpha level be for the Johnson-Neyman
interval? Default is .05, which corresponds to a 95\% confidence interval.}

\item{robust}{Should robust standard errors be used to find confidence
intervals for supported models? Default is FALSE, but you should specify
the type of sandwich standard errors if you'd like to use them (i.e.,
\code{"HC0"}, \code{"HC1"}, and so on). If \code{TRUE}, defaults to \code{"HC3"} standard
errors.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{pvals}{Show p values? If \code{FALSE}, these
are not printed. Default is \code{TRUE}.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{cluster}{For clustered standard errors, provide the column name of
the cluster variable in the input data frame (as a string). Alternately,
provide a vector of clusters.}

\item{modx.labels}{A character vector of labels for each level of the
moderator values, provided in the same order as the \code{modx.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{modx,values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd
moderator values, provided in the same order as the \code{mod2.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{mod2.values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{v.cov}{A function to calculate variances for the model. Examples
could be \code{\link[sandwich:vcovPC]{sandwich::vcovPC()}}.}

\item{v.cov.args}{A list of arguments for the \code{v.cov} function. For
whichever argument should be the fitted model, put \code{"model"}.}

\item{...}{Arguments passed to \code{\link{johnson_neyman}} and
\code{summ}.}
}
\value{
A list object with the following components:

\item{slopes}{A table of coefficients for the focal predictor at each
value of the moderator}
\item{ints}{A table of coefficients for the intercept at each value of the
moderator}
\item{modx.values}{The values of the moderator used in the analysis}
\item{mods}{A list containing each regression model created to estimate
the conditional coefficients.}
\item{jn}{If \code{johnson_neyman = TRUE}, a list of \code{johnson_neyman}
objects from \code{\link{johnson_neyman}}. These contain the values of the
interval and the plots. If a 2-way interaction, the list will be of length
\enumerate{
\item Otherwise, there will be 1 \code{johnson_neyman} object for each value of
the
2nd moderator for 3-way interactions.}
}
}
\description{
\code{sim_slopes} conducts a simple slopes analysis for the purposes of
understanding two- and three-way interaction effects in linear regression.
}
\details{
This allows the user to perform a simple slopes analysis for the
purpose of probing interaction effects in a linear regression. Two- and
three-way interactions are supported, though one should be warned that
three-way interactions are not easy to interpret in this way.

For more about Johnson-Neyman intervals, see \code{\link{johnson_neyman}}.

The function is tested with \code{lm}, \code{glm}, \code{svyglm}, and \code{merMod} inputs.
Others may work as well, but are not tested. In all but the linear model
case, be aware that not all the assumptions applied to simple slopes
analysis apply.
}
\examples{

# Using a fitted model as formula input
fiti <- lm(Income ~ Frost + Murder * Illiteracy,
  data = as.data.frame(state.x77))
sim_slopes(model = fiti, pred = Murder, modx = Illiteracy)

# With svyglm
if (requireNamespace("survey")) {
library(survey)
data(api)
dstrat <- svydesign(id = ~1, strata = ~stype, weights = ~pw,
                    data = apistrat, fpc = ~fpc)
regmodel <- svyglm(api00 ~ ell * meals, design = dstrat)
sim_slopes(regmodel, pred = ell, modx = meals)

# 3-way with survey and factor input
regmodel <- svyglm(api00 ~ ell * meals * sch.wide, design = dstrat)
sim_slopes(regmodel, pred = ell, modx = meals, mod2 = sch.wide)
}

}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and
multilevel regression: Inferential and graphical techniques.
\emph{Multivariate Behavioral Research}, \emph{40}(3), 373-400.
\url{http://dx.doi.org/10.1207/s15327906mbr4003_5}

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). \emph{Applied
multiple regression/correlation analyses for the behavioral sciences} (3rd
ed.). Mahwah, NJ: Lawrence Erlbaum Associates, Inc.
}
\seealso{
\code{\link{interact_plot}} accepts similar syntax and will plot the
results with \code{\link[ggplot2]{ggplot}}.

\code{\link[rockchalk]{testSlopes}} performs a hypothesis test of
differences and provides Johnson-Neyman intervals.

\code{\link[pequod]{simpleSlope}} performs a similar analysis.

Other interaction tools: 
\code{\link{johnson_neyman}()},
\code{\link{probe_interaction}()},
\code{\link{sim_margins}()}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
\concept{interaction tools}
