% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssmle_aipw.R
\name{bssmle_aipw}
\alias{bssmle_aipw}
\title{B-spline Sieve Maximum Likelihood Estimation for Interval-Censored Competing Risks Data and Missing Cause of Failure}
\usage{
bssmle_aipw(formula, aux, data, alpha, k)
}
\arguments{
\item{formula}{a formula object relating survival object \code{Surv2(v, u, event)} to a set of covariates}

\item{aux}{auxiliary variables that may be associated with the missingness and the outcome of interest}

\item{data}{a data frame that includes the variables named in the formula argument}

\item{alpha}{\eqn{\alpha = (\alpha1, \alpha2)} contains parameters that define the link functions from class of generalized odds-rate transformation models. The components \eqn{\alpha1} and \eqn{\alpha2} should both be \eqn{\ge 0}. If \eqn{\alpha1 = 0}, the user assumes the proportional subdistribution hazards model or the Fine-Gray model for the event type 1. If \eqn{\alpha2 = 1}, the user assumes the proportional odds model for the event type 2.}

\item{k}{a parameter that controls the number of knots in the B-spline with \eqn{0.5 \le }\code{k}\eqn{ \le 1}}
}
\value{
The function \code{bssmle_aipw} returns a list of components:
\item{beta}{a vector of the estimated coefficients for the B-splines}
\item{varnames}{a vector containing variable names}
\item{varnames.aux}{a vector containing auxiliary variable names}
\item{alpha}{a vector of the link function parameters}
\item{loglikelihood}{a loglikelihood of the fitted model}
\item{convergence}{an indicator of convegence}
\item{tms}{a vector of the minimum and maximum observation times}
\item{Bv}{a list containing the B-splines basis functions evaluated at \code{v}}
}
\description{
Routine that performs B-spline sieve maximum likelihood estimation with linear and nonlinear inequality and equality constraints
}
\details{
The function \code{bssmle_aipw} performs B-spline sieve maximum likelihood estimation.
}
\author{
Jun Park, \email{jp84 at iu dot edu}

Giorgos Bakoyannis, \email{gbakogia at iu dot edu}
}
\keyword{bssmle_aipw}
