% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_cmdstan_exists.R
\name{stan_cmdstan_exists}
\alias{stan_cmdstan_exists}
\title{Check if \code{instantiate} can find CmdStanR and CmdStan.}
\usage{
stan_cmdstan_exists(
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL", unset = "")
)
}
\arguments{
\item{cmdstan_install}{Character of length 1, how to look for an installed
copy of CmdStan. See \url{https://wlandau.github.io/instantiate/} for details.
Choices:
\enumerate{
\item \code{""} (default): look at the original value that the \code{CMDSTAN_INSTALL}
environment variable contained when \code{instantiate} at the time
when it was installed.
If it was \code{"implicit"} or \code{"fixed"}, then choose
the corresponding option below. Otherwise, default to \code{"implicit"}.
\item \code{"implicit"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. As explained in the \code{cmdstanr} documentation,
the output of \code{cmdstanr::cmdstan_path()} depends
on the current value of the \code{CMDSTAN} environment variable.
The \code{cmdstanr} package must be installed. If it
is not installed, then \code{stan_cmdstan_path()}
returns the empty string \code{""}.
\item \code{"fixed"}: Use the path to CmdStan that was originally
contained in \code{Sys.getenv("CMDSTAN")} at the time when \code{instantiate}
was installed.
}}
}
\value{
\code{TRUE} if \code{instantiate} can find the CmdStanR R package and the
CmdStan command line tool. Returns \code{FALSE} otherwise.
}
\description{
Check if \code{instantiate} can find CmdStanR and CmdStan.
}
\examples{
stan_cmdstan_exists()
}
\seealso{
Other cmdstan: 
\code{\link{stan_cmdstan_version}()}
}
\concept{cmdstan}
