% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_plot.R
\name{show_plot}
\alias{show_plot}
\title{Simple graphical inspection of dataframe summaries}
\usage{
show_plot(
  x,
  text_labels = TRUE,
  alpha = 0.05,
  high_cardinality = 0,
  plot_layout = NULL,
  col_palette = 0,
  plot_type = 1,
  label_thresh = 0.1,
  label_angle = NULL,
  label_color = NULL,
  label_size = NULL
)
}
\arguments{
\item{x}{Dataframe resulting from a call to an \code{inspect_*()} function.}

\item{text_labels}{Boolean.  Whether to show text annotation on plots.  Defaults to \code{TRUE}.}

\item{alpha}{Alpha level for performing any significance tests.  Defaults to 0.05.}

\item{high_cardinality}{Minimum number of occurrences of category to be shown as a distinct segment 
in the plot (\code{inspect_cat()} only).  Default is 0 - all distinct levels are shown.  Setting 
\code{high_cardinality > 0} can speed up plot rendering when categorical columns contain 
many near-unique values.}

\item{plot_layout}{Vector specifying the number of rows and columns 
in the plotting grid.  For example, 3 rows and 2 columns would be specified as 
\code{plot_layout = c(3, 2)}.}

\item{col_palette}{Integer indicating the colour palette to use:
\itemize{
\item \code{0}: (default) `ggplot2` color palette
\item \code{1}: a \href{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/}{colorblind friendly palette}
\item \code{2}: \href{https://www.color-hex.com/color-palette/25888}{80s theme}
\item \code{3}: \href{https://www.color-hex.com/color-palette/79261}{rainbow theme}
\item \code{4}: \href{https://www.color-hex.com/color-palette/78663}{mario theme}
\item \code{5}: \href{https://www.color-hex.com/color-palette/78664}{pokemon theme}
}}

\item{plot_type}{Experimental.  Integer determining plot type to print.  Defaults to 1.}

\item{label_thresh}{(\code{inspect_cat()} only.  Minimum occurrence frequency of category for 
a text label to be shown.  Smaller values of \code{label_thresh} will show labels 
for less common categories but at the expense of increased plot rendering time.  Defaults to 0.1.}

\item{label_angle}{Numeric value specifying angle with which to rotate text annotation, 
if applicable.  Defaults to 90 for most plots.}

\item{label_color}{Character string or character vector specifying colors for text annotation, 
if applicable.  Usually defaults to white and gray.}

\item{label_size}{Numeric value specifying font size for text annotation, if applicable.}
}
\description{
Easily visualise output from \code{inspect_*()} functions.
}
\examples{
# Load 'starwars' data
data("starwars", package = "dplyr")

# Horizontal bar plot for categorical column composition
x <- inspect_cat(starwars) 
show_plot(x)

# Correlation betwee numeric columns + confidence intervals
x <- inspect_cor(starwars)
show_plot(x)

# Bar plot of most frequent category for each categorical column
x <- inspect_imb(starwars)
show_plot(x)

# Bar plot showing memory usage for each column
x <- inspect_mem(starwars)
show_plot(x)

# Occurence of NAs in each column ranked in descending order
x <- inspect_na(starwars)
show_plot(x)

# Histograms for numeric columns
x <- inspect_num(starwars)
show_plot(x)

# Barplot of column types
x <- inspect_types(starwars)
show_plot(x)
}
