% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_cor.R
\name{inspect_cor}
\alias{inspect_cor}
\title{Summarise and compare Pearson's correlation coefficients for numeric columns in one or two dataframes.}
\usage{
inspect_cor(df1, df2 = NULL, show_plot = FALSE, alpha = 0.05,
  absolute = TRUE)
}
\arguments{
\item{df1}{A data frame}

\item{df2}{An optional second data frame for comparing correlation 
coefficients.  Defaults to \code{NULL}.}

\item{show_plot}{Logical argument determining whether plot is returned
in addition to tibble output.  Default is \code{FALSE}.}

\item{alpha}{Alpha level for performing tests of correlation coefficient equality.
Defaults to 0.05.}

\item{absolute}{Logical flag indicating whether to plot correlations on an absolute scale.
Note that this is just a display option and all tests and comparisons occur on the original 
correlation scale regardless of this flag.}
}
\value{
A tibble summarising and comparing the correlations for each numeric column 
in one or a pair of data frames.
}
\description{
Summarise and compare Pearson's correlation coefficients for numeric columns in one or two dataframes.
}
\details{
When only \code{df1} is specified, a tibble is returned which 
contains correlation coefficients 
\itemize{
  \item \code{col_1}, \code{co1_2} character vectors containing names of numeric columns in \code{df1}.
  \item \code{corr} numeric values of Pearson's correlation coefficient.
  \item \code{lower}, \code{upper} lower and upper values of the confidence interval for the correlations.
  \item \code{p_value} p-value associated with the null hypothesis of 0 correlation, small values 
  indicate evidence that the true correlation is not equal to 0.
}
When both \code{df1} and \code{df2} are specified, the tibble returned performs a comparison of the 
correlation coefficients across the dataframes.
\itemize{
  \item \code{col_1}, \code{co1_2} character vectors containing names of numeric columns in either 
  \code{df1} or \code{df2}.
  \item \code{corr_1}, \code{corr_2} numeric values of Pearson's correlation coefficient observed in 
  \code{df1} and \code{df2}, respectively.
  \item \code{p_value} p-value associated with the null hypothesis that the two correlation coefficients 
  are the same.  Small values indicate that the true correlation coefficients differ between the two 
  dataframes.
}
}
\examples{
data("starwars", package = "dplyr")
# correlations in numeric columns
inspect_cor(starwars)
# get visualisation with confidence bands
inspect_cor(starwars, show_plot = TRUE)
# compare correlations with a different data frame
inspect_cor(starwars, starwars[1:10, ], show_plot = TRUE)
}
