% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_table.R
\name{export_table}
\alias{export_table}
\title{Data frame and Tables Pretty Formatting}
\usage{
export_table(
  x,
  sep = " | ",
  header = "-",
  empty_line = NULL,
  digits = 2,
  protect_integers = TRUE,
  missing = "",
  width = NULL,
  format = NULL,
  title = NULL,
  caption = title,
  subtitle = NULL,
  footer = NULL,
  align = NULL,
  group_by = NULL,
  zap_small = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A data frame.}

\item{sep}{Column separator.}

\item{header}{Header separator. Can be \code{NULL}.}

\item{empty_line}{Separator used for empty lines. If \code{NULL}, line remains
empty (i.e. filled with whitespaces).}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link{signif}}).}

\item{protect_integers}{Should integers be kept as integers (i.e., without
decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an
empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and
\code{width} is larger than the string's length, leading whitespaces are
added to the string.}

\item{format}{Name of output-format, as string. If \code{NULL} (or \code{"text"}),
returned output is used for basic printing. Can be one of \code{NULL} (the
default) resp. \code{"text"} for plain text, \code{"markdown"} (or
\code{"md"}) for markdown and \code{"html"} for HTML output.}

\item{title, caption, subtitle}{Table title (same as caption) and subtitle, as strings. If \code{NULL},
no title or subtitle is printed, unless it is stored as attributes (\code{table_title},
or its alias \code{table_caption}, and \code{table_subtitle}).}

\item{footer}{Table footer, as string. For markdown-formatted tables, table
footers, due to the limitation in markdown rendering, are actually just a
new text line under the table.}

\item{align}{Column alignment. For markdown-formatted tables, the default
\code{align = NULL} will right-align numeric columns, while all other
columns will be left-aligned. If \code{format = "html"}, the default is
left-align first column and center all remaining. May be a string to
indicate alignment rules for the complete table, like \code{"left"},
\code{"right"}, \code{"center"} or \code{"firstleft"} (to left-align first
column, center remaining); or maybe a string with abbreviated alignment
characters, where the length of the string must equal the number of columns,
for instance, \code{align = "lccrl"} would left-align the first column, center
the second and third, right-align column four and left-align the fifth
column. For HTML-tables, may be one of \code{"center"}, \code{"left"} or
\code{"right"}.}

\item{group_by}{Name of column in \code{x} that indicates grouping for tables.
Only applies when \code{format = "html"}. \code{group_by} is passed down
to \code{gt::gt(groupname_col = group_by)}.}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after
\code{digits} decimal places. If \code{FALSE}, values with more decimal
places than \code{digits} are printed in scientific notation.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
A data frame in character format.
}
\description{
Data frame and Tables Pretty Formatting
}
\note{
The values for \code{caption}, \code{subtitle} and \code{footer}
  can also be provided as attributes of \code{x}, e.g. if \code{caption = NULL}
  and \code{x} has attribute \code{table_caption}, the value for this
  attribute will be used as table caption. \code{table_subtitle} is the
  attribute for \code{subtitle}, and \code{table_footer} for \code{footer}.
}
\examples{
cat(export_table(iris))
cat(export_table(iris, sep = " ", header = "*", digits = 1))
\dontrun{
# colored footers
data(iris)
x <- as.data.frame(iris[1:5, ])
attr(x, "table_footer") <- c("This is a yellow footer line.", "yellow")
cat(export_table(x))

attr(x, "table_footer") <- list(
  c("\nA yellow line", "yellow"),
  c("\nAnd a red line", "red"),
  c("\nAnd a blue line", "blue")
)
cat(export_table(x))

attr(x, "table_footer") <- list(
  c("Without the ", "yellow"),
  c("new-line character ", "red"),
  c("we can have multiple colors per line.", "blue")
)
cat(export_table(x))
}
}
\seealso{
Vignettes \href{https://easystats.github.io/insight/articles/display.html}{Formatting, printing and exporting tables}
and \href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{Formatting model parameters}.
}
