% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{standardize_initialization}
\alias{standardize_initialization}
\title{Standardize initialization}
\usage{
standardize_initialization(
  x,
  arg = "data",
  by_col = TRUE,
  center = TRUE,
  scale = TRUE,
  ind_ign = integer(),
  initialization = random_initialization(),
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress"),
  label = "standardize"
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{arg}{A character, the name of the argument to be standardized.
The argument must be of class \code{matrix} or \code{data.frame}.
Per default, \code{arg = "data"}.}

\item{by_col}{A boolean, set to \code{TRUE} (the default) to standardize column-wise, set
to \code{FALSE} to standardize by rows.}

\item{center}{A boolean, set to \code{TRUE} (the default) for mean standardization.}

\item{scale}{A boolean, set to \code{TRUE} (the default) for variance standardization.}

\item{ind_ign}{A numeric vector of column indices (or row indices if \code{by_col = FALSE})
that are ignored when standardizing.}

\item{initialization}{An object of class \code{strategy_call} which determines the initialization.
The \code{strategy_call} can be generated by one of the strategy functions
(any function with the name \code{*_initialization}), when the \code{x}
argument is unspecified.
Per default, \code{initialization = random_initialization()}, i.e. random
initialization.}

\item{ncores}{The number of cores for parallel computation over parameters and optimizers.
The default is \code{getOption("ino_ncores")}, which is set to \code{1}
when the package is loaded.}

\item{verbose}{A boolean, which indicates whether progress should be printed.
Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.
The default is \code{getOption("ino_progress")}, which is set to \code{TRUE}
when the package is loaded.}

\item{label}{A character, the label for the initialization strategy.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the standardize initialization
strategy.
}
\keyword{strategy}
