% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_integration.R
\name{fm_int}
\alias{fm_int}
\alias{fm_int.list}
\alias{fm_int.numeric}
\alias{fm_int.character}
\alias{fm_int.factor}
\alias{fm_int.SpatRaster}
\alias{fm_int.inla.mesh.lattice}
\alias{fm_int.inla.mesh.1d}
\alias{fm_int.inla.mesh}
\title{Multi-domain integration}
\usage{
fm_int(domain, samplers = NULL, ...)

\method{fm_int}{list}(domain, samplers = NULL, ...)

\method{fm_int}{numeric}(domain, samplers = NULL, name = "x", ...)

\method{fm_int}{character}(domain, samplers = NULL, name = "x", ...)

\method{fm_int}{factor}(domain, samplers = NULL, name = "x", ...)

\method{fm_int}{SpatRaster}(domain, samplers = NULL, name = "x", ...)

\method{fm_int}{inla.mesh.lattice}(domain, samplers = NULL, name = "x", ...)

\method{fm_int}{inla.mesh.1d}(domain, samplers = NULL, name = "x", int.args = NULL, ...)

\method{fm_int}{inla.mesh}(
  domain,
  samplers = NULL,
  name = NULL,
  int.args = NULL,
  format = NULL,
  ...
)
}
\arguments{
\item{domain}{Functional space specification; single domain or a named list
of domains}

\item{samplers}{For single domain \code{fm_int} methods, an object specifying one or more
subsets of the domain, and optional weighting in a \code{weight} variable.
For \code{fm_int.list}, a list of sampling definitions, where data frame elements
may contain information for multiple domains, in which case each row represent
a separate tensor product integration subspace.}

\item{\dots}{Additional arguments passed on to other methods}

\item{name}{For single-domain methods, the variable name to use for the
integration points. Default 'x'}

\item{int.args}{List of arguments passed to line and integration methods.
\itemize{
\item \code{method}: "stable" (to aggregate integration weights onto mesh nodes)
or "direct" (to construct a within triangle/segment integration scheme
without aggregating onto mesh nodes)
\item \code{nsub1}, \code{nsub2}: integers controlling the number of internal integration
points before aggregation. Points per triangle: \code{(nsub2+1)^2}.
Points per knot segment: \code{nsub1}
}}

\item{format}{character; determines the output format, as either "sf"
(default when the sampler is \code{NULL}) or "sp". When \code{NULL}, determined by
the sampler type.}
}
\value{
A \code{data.frame}, \code{tibble}, \code{sf}, or \code{SpatialPointsDataFrame} of 1D and
2D integration points, including a \code{weight} column and \code{.block} column.
}
\description{
Construct integration points on tensor product spaces
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_int(list)}: Multi-domain integration

\item \code{fm_int(numeric)}: Discrete double or integer space integration

\item \code{fm_int(character)}: Discrete character space integration

\item \code{fm_int(factor)}: Discrete factor space integration

\item \code{fm_int(SpatRaster)}: \code{SpatRaster} integration. Not yet implemented.

\item \code{fm_int(inla.mesh.lattice)}: \code{inla.mesh.lattice} integration. Not yet implemented.

\item \code{fm_int(inla.mesh.1d)}: \code{inla.mesh.1d} integration. Supported samplers:
\itemize{
\item \code{NULL} for integration over the entire domain;
\item A length 2 vector defining an interval;
\item A 2-column matrix with a single interval in each row;
\item A tibble with a named column containing a matrix, and optionally a
\code{weight} column.
}

\item \code{fm_int(inla.mesh)}: \code{inla.mesh} integration. Any sampler class with an
associated \code{\link[=fm_int_inla_mesh]{fm_int_inla_mesh()}} method is supported.

}}
\examples{
if (bru_safe_inla() && bru_safe_sp()) {
  # Integration on the interval (2, 3.5) with Simpson's rule
  ips <- fm_int(INLA::inla.mesh.1d(0:4), samplers = cbind(2, 3.5))
  plot(ips)

  # Create integration points for the two intervals [0,3] and [5,10]

  ips <- fm_int(
    INLA::inla.mesh.1d(0:10),
    matrix(c(0, 3, 5, 10), nrow = 2, byrow = TRUE)
  )
  plot(ips)

  # Convert a 1D mesh into integration points
  mesh <- INLA::inla.mesh.1d(seq(0, 10, by = 1))
  ips <- fm_int(mesh, name = "time")
  plot(ips)


  if (require("ggplot2", quietly = TRUE)) {
    data("gorillas", package = "inlabru")
    #' Integrate on a 2D mesh with polygon boundary subset
    ips <- fm_int(gorillas$mesh, gorillas$boundary)
    ggplot() +
      gg(gorillas$mesh) +
      gg(gorillas$boundary) +
      gg(ips, aes(size = weight)) +
      scale_size_area()
  }
}

}
