% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper}
\alias{bru_mapper}
\alias{bru_mapper_define}
\alias{bru_mapper.default}
\alias{bru_mapper.inla.mesh}
\alias{bru_mapper.inla.mesh.1d}
\alias{bru_mapper_index}
\alias{bru_mapper_taylor}
\alias{bru_mapper_linear}
\alias{bru_mapper_matrix}
\alias{bru_mapper_factor}
\alias{bru_mapper_const}
\alias{bru_mapper_offset}
\alias{bru_mapper_scale}
\alias{bru_mapper_multi}
\alias{bru_mapper_collect}
\alias{bru_mapper_harmonics}
\title{Constructors for \code{bru_mapper} objects}
\usage{
bru_mapper(...)

bru_mapper_define(mapper, new_class = NULL, methods = NULL, ...)

\method{bru_mapper}{default}(...)

\method{bru_mapper}{inla.mesh}(mesh, ...)

\method{bru_mapper}{inla.mesh.1d}(mesh, indexed = NULL, ...)

bru_mapper_index(n = 1L, ...)

bru_mapper_taylor(offset, jacobian, state0, ..., values_mapper = NULL)

bru_mapper_linear(...)

bru_mapper_matrix(labels, ...)

bru_mapper_factor(values, factor_mapping, ...)

bru_mapper_const(...)

bru_mapper_offset(...)

bru_mapper_scale(mapper, ...)

bru_mapper_multi(mappers, ...)

bru_mapper_collect(mappers, hidden = FALSE, ...)

bru_mapper_harmonics(
  order = 1,
  scaling = 1,
  intercept = TRUE,
  interval = c(0, 1),
  ...
)
}
\arguments{
\item{\dots}{Deprecated, alternative way to supply optional method definitions.}

\item{mapper}{For \code{bru_mapper_define}, a prototype mapper object, see Details.
For \code{bru_mapper_scale}, a mapper to be scaled.}

\item{new_class}{If non-\code{NULL}, this is added at the front of the class definition}

\item{methods}{Optional \code{list} of named method definitions; See Details.}

\item{mesh}{An \code{inla.mesh.1d} or \code{inla.mesh.2d} object to use as a mapper}

\item{indexed}{logical; If \code{TRUE}, the \code{ibm_values()} output will be the
integer indexing sequence for the latent variables (needed for \code{spde} models).
If \code{FALSE}, the knot
locations are returned (useful as an interpolator for \code{rw2} models
and similar).
Default: \code{NULL}, to force user specification of this parameter}

\item{n}{Size of a model for \code{bru_mapper_index}}

\item{offset}{For \code{bru_mapper_taylor}, an offset vector evaluated
at \code{state0}}

\item{jacobian}{For \code{bru_mapper_taylor}, the Jacobian matrix,
evaluated at \code{state0}, or, a named list of such matrices.
May be \code{NULL} or an empty list, for a constant mapping.}

\item{state0}{For \code{bru_mapper_taylor}, the state the linearisation
was evaluated at, or a list of length matching the \code{jacobian} list.
\code{NULL} is interpreted as 0.}

\item{values_mapper}{mapper object to be used for \code{ibm_n} and
\code{ibm_values} for \code{inla_f=TRUE} (experimental, currently unused)}

\item{labels}{Column labels for matrix mappings}

\item{values}{Input values calculated by \code{\link[=input_eval.bru_input]{input_eval.bru_input()}}}

\item{factor_mapping}{character; selects the type of factor mapping.
\itemize{
\item \code{'contrast'} for leaving out the first factor level.
\item \code{'full'} for keeping all levels.
}}

\item{mappers}{A list of \code{bru_mapper} objects}

\item{hidden}{\code{logical}, set to \code{TRUE} to flag that the mapper is to be used
as a first level input mapper for \code{INLA::f()} in a model that requires making
only the first mapper visible to \code{INLA::f()} and \code{INLA::inla.stack()}, such
as for "bym2" models, as activated by the \code{inla_f} argument to \code{ibm_n},
\code{ibm_values}, and \code{ibm_jacobian}. Set to \code{FALSE} to always access the full
mapper, e.g. for \code{rgeneric} models}

\item{order}{For \code{bru_mapper_harmonics}, specifies the maximum \code{cos}/\code{sin}
order. (Default 1)}

\item{scaling}{For \code{bru_mapper_harmonics}, specifies an optional vector of
scaling factors of length \code{intercept + order}, or a common single scalar.}

\item{intercept}{logical; For \code{bru_mapper_harmonics}, if \code{TRUE}, the first
basis function is a constant. (Default \code{TRUE})}

\item{interval}{numeric length-2 vector specifying a domain interval.
Default \code{c(0, 1)}.}
}
\description{
Constructors for \code{bru_mapper} objects
}
\details{
\itemize{
\item \code{bru_mapper} Generic mapper S3 constructor, used for constructing
mappers for special objects. See below for details of the
default constructor \code{\link[=bru_mapper_define]{bru_mapper_define()}} that can be used to define
new mappers in user code.
}

\itemize{
\item \code{bru_mapper_define} adds the \code{new_class} and "bru_mapper" class
names to the inheritance list for the input \code{mapper} object, unless the object
already inherits from these.
If provided, mapper method functions are added to an environment
\code{.envir} in the object.  The generic methods look for these
functions first,
and otherwise call \code{UseMethod()}.  This is an alternative to using \code{.S3method()}
to register the methods, e.g.
\code{.S3method("ibm_jacobian", "my_mapper_class", ibm_jacobian.my_mapper_class)}.
}

\itemize{
\item \code{bru_mapper.default} calls \code{bru_mapper_define}, passing all
arguments along. Mapper implementations should call \code{\link[=bru_mapper_define]{bru_mapper_define()}}
instead, and supply at least a \code{new_class} class name.
Use of the \code{bru_mapper.default} will be deprecated from version 2.7.0.
}

\code{bru_mapper_taylor} provides a pre-computed affine mapping,
internally used to represent and evaluate linearisation information.
The \code{state0} information indicates for which state the \code{offset} was evaluated;
The affine mapper output is defined as
\code{effect(state) = offset + jacobian \%*\% (state - state0)}

For \code{bru_mapper_scale()}, \code{mapper} is a mapper to be scaled.
The \code{input} format for the \code{ibm_eval} and \code{ibm_jacobian} methods is
\code{list(mapper = input_to_the_inner_mapper, scale = scaling_weights)}

\itemize{
\item \code{bru_mapper_multi} constructs a kronecker product mapping
}

\itemize{
\item \code{bru_mapper_collect} constructs concatenated collection mapping
}

\itemize{
\item \code{bru_mapper_harmonics} constructs a mapper for \code{cos}/\code{sin} functions
of orders 1 (if \code{intercept} is \code{TRUE}, otherwise 0) through \code{order}. The total
number of basis functions is \code{intercept + 2 * order}.

Optionally, each order can be given a non-unit scaling, via the \code{scaling}
vector, of length \code{intercept + order}. This can be used to
give an effective spectral prior. For example, let

\if{html}{\out{<div class="sourceCode">}}\preformatted{scaling = 1 / (1 + (0:4)^2)
A1 = bru_mapper_harmonics(order = 4)
u1 <- A1 \%*\% rnorm(9, sd = scaling)
}\if{html}{\out{</div>}}

Then, with

\if{html}{\out{<div class="sourceCode">}}\preformatted{A2 = bru_mapper_harmonics(order = 4, scaling = scaling)
u2 = A2 \%*\% rnorm(9)
}\if{html}{\out{</div>}}

the stochastic properties of \code{u1} and \code{u2} will be the same, with \code{scaling^2}
determining the variance for each frequency contribution.

The period for the first order harmonics is shifted and scaled to match
\code{interval}.
}
}
\examples{
mapper <- bru_mapper_index(5)
ibm_jacobian(mapper, input = c(1, 3, 4, 5, 2))
}
\seealso{
\link{bru_mapper_methods} for specific method implementations, and
\link{bru_get_mapper} for hooks to extract mappers from latent model object
class objects.
}
