% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{pixels}
\alias{pixels}
\title{Generate \code{SpatialPixels} covering an \code{inla.mesh}}
\usage{
pixels(mesh, nx = 150, ny = 150, mask = TRUE)
}
\arguments{
\item{mesh}{An \code{inla.mesh} object}

\item{nx}{Number of pixels in x direction}

\item{ny}{Number of pixels in y direction}

\item{mask}{If logical and TRUE, remove pixels that are outside the mesh.
If \code{mask} is a \code{Spatial} object, only return pixels covered by this object.}
}
\value{
\code{SpatialPixelsDataFrame} covering the mesh
}
\description{
Generate \code{SpatialPixels} covering an \code{inla.mesh}
}
\examples{
\donttest{
data("mrsea")
pxl <- pixels(mrsea$mesh, nx = 50, ny = 50, mask = mrsea$boundary)
ggplot() +
  gg(pxl, fill = "grey", alpha = 0.5) +
  gg(mrsea$mesh)
}

}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
}
