% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_const}
\alias{bru_mapper_const}
\alias{ibm_n.bru_mapper_const}
\alias{ibm_values.bru_mapper_const}
\alias{ibm_jacobian.bru_mapper_const}
\alias{ibm_eval.bru_mapper_const}
\title{Constant mapper}
\usage{
bru_mapper_const()

\method{ibm_n}{bru_mapper_const}(mapper, ...)

\method{ibm_values}{bru_mapper_const}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_const}(mapper, input, ...)

\method{ibm_eval}{bru_mapper_const}(mapper, input, state = NULL, ...)
}
\arguments{
\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\description{
Create a constant mapper
}
\examples{
m <- bru_mapper_const()
ibm_eval2(m, input = 1:4)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
