% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{neighborhood.connectivity}
\alias{neighborhood.connectivity}
\alias{NC}
\title{Neighborhood connectivity}
\usage{
neighborhood.connectivity(graph, vertices, mode = "all")
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{mode}{The mode of neighborhood connectivity depending on the directedness of the graph.
If the graph is undirected, the mode "all" should be specified.
Otherwise, for the calculation of neighborhood connectivity based on
incoming connections select "in" and for the outgoing connections select "out".
Also, if all of the connections are desired, specify the "all" mode. Default mode is set to "all".}
}
\value{
A one column data frame with vertex names in vertices as row names and neighborhood connectivity score
of each vertex in the column.
}
\description{
This function calculates the neighborhood connectivity of input vertices and
works with both directed and undirected networks.
}
\examples{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
neighrhood.co <- neighborhood.connectivity(graph = My_graph,
                                           vertices = GraphVertices,
                                           mode = "all")
}
\seealso{
Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{degree}()}
}
\concept{centrality functions}
\keyword{neighborhood_connectivity}
