% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_confidence_interval.R
\name{get_confidence_interval}
\alias{get_confidence_interval}
\alias{get_ci}
\title{Compute confidence interval}
\usage{
get_confidence_interval(
  x,
  level = 0.95,
  type = "percentile",
  point_estimate = NULL
)

get_ci(x, level = 0.95, type = "percentile", point_estimate = NULL)
}
\arguments{
\item{x}{Data frame of calculated statistics or containing attributes of
theoretical distribution values. Currently, dependent on statistics being
stored in \code{stat} column as created in \code{\link[=calculate]{calculate()}} function.}

\item{level}{A numerical value between 0 and 1 giving the confidence level.
Default value is 0.95.}

\item{type}{A string giving which method should be used for creating the
confidence interval. The default is \code{"percentile"} with \code{"se"}
corresponding to (multiplier * standard error) and \code{"bias-corrected"} for
bias-corrected interval as other options.}

\item{point_estimate}{A numeric value or a 1x1 data frame set to \code{NULL} by
default. Needed to be provided if \code{type} is \code{"se"} or \code{"bias-corrected"}.}
}
\value{
A 1 x 2 tibble with 'lower_ci' and 'upper_ci' columns. Values
correspond to lower and upper bounds of the confidence interval.
}
\description{
Compute a confidence interval around a summary statistic. Currently, only
simulation-based methods are supported.

Learn more in \code{vignette("infer")}.
}
\details{
A null hypothesis is not required to compute a confidence interval, but
including \code{hypothesize()} in a chain leading to \code{get_confidence_interval()}
will not break anything. This can be useful when computing a confidence
interval after previously computing a p-value.
}
\section{Aliases}{

\code{get_ci()} is an alias of \code{get_confidence_interval()}.
\code{conf_int()} is a deprecated alias of \code{get_confidence_interval()}.
}

\examples{

boot_distr <- gss \%>\%
  # We're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # Generate bootstrap samples
  generate(reps = 1000, type = "bootstrap") \%>\%
  # Calculate mean of each bootstrap sample
  calculate(stat = "mean")

boot_distr \%>\%
  # Calculate the confidence interval around the point estimate
  get_confidence_interval(
    # At the 95\% confidence level; percentile method
    level = 0.95
  )

# For type = "se" or type = "bias-corrected" we need a point estimate
sample_mean <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()

boot_distr \%>\%
  get_confidence_interval(
    point_estimate = sample_mean,
    # At the 95\% confidence level
    level = 0.95,
    # Using the standard error method
    type = "se"
  )

# More in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}

}
