% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_value.R
\name{get_p_value}
\alias{get_p_value}
\alias{get_pvalue}
\title{Compute p-value}
\usage{
get_p_value(x, obs_stat, direction)

get_pvalue(x, obs_stat, direction)
}
\arguments{
\item{x}{Data frame of calculated statistics as returned by \code{\link[=generate]{generate()}}}

\item{obs_stat}{A numeric value or a 1x1 data frame (as extreme or more
extreme than this).}

\item{direction}{A character string. Options are \code{"less"}, \code{"greater"}, or
\code{"two_sided"}. Can also use \code{"left"}, \code{"right"}, or \code{"both"}.}
}
\value{
A 1x1 \link[tibble:tibble]{tibble} with value between 0 and 1.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}

Compute a p-value from a null distribution and observed statistc.
Simulation-based methods are (currently only) supported.

Learn more in \code{vignette("infer")}.
}
\section{Aliases}{

\code{get_pvalue()} is an alias of \code{get_p_value()}.
\code{p_value} is a deprecated alias of \code{get_p_value()}.
}

\examples{

# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()

# starting with the gss dataset
gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 10000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean") \%>\%
  get_p_value(obs_stat = point_estimate, direction = "two_sided")
  
# More in-depth explanation of how to use the infer package
vignette("infer")   
  
}
