% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\title{Generate resamples, permutations, or simulations}
\usage{
generate(x, reps = 1, type = NULL, ...)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{reps}{The number of resamples to generate.}

\item{type}{Currently either \code{bootstrap}, \code{permute}, or \code{simulate}
(see below).}

\item{...}{Currently ignored.}
}
\value{
A tibble containing \code{reps} generated datasets, indicated by the
\code{replicate} column.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("questioning")}

Generation creates a null distribution from \code{\link[=specify]{specify()}} and (if needed)
\code{\link[=hypothesize]{hypothesize()}} inputs.

Learn more in \code{vignette("infer")}.
}
\section{Generation Types}{


The \code{type} argument determines the method used to create the null
distribution.

\itemize{
\item \code{bootstrap}: A bootstrap sample will be drawn for each replicate,
where a sample of size equal to the input sample size is drawn (with
replacement) from the input sample data.
\item \code{permute}: For each replicate, each input value will be randomly
reassigned (without replacement) to a new output value in the sample.
\item \code{simulate}: A value will be sampled from a theoretical distribution
with parameters specified in \code{\link[=hypothesize]{hypothesize()}} for each replicate. (This
option is currently only applicable for testing point estimates.)
}
}

\examples{
# Generate a null distribution by taking 1000 bootstrap samples
gss \%>\%
 specify(response = hours) \%>\%
 hypothesize(null = "point", mu = 40) \%>\%
 generate(reps = 1000, type = "bootstrap")

# Generate a null distribution for the independence of
# two variables by permuting their values 1000 times
gss \%>\%
 specify(partyid ~ age) \%>\%
 hypothesize(null = "independence") \%>\%
 generate(reps = 1000, type = "permute")

# More in-depth explanation of how to use the infer package
vignette("infer")

}
