% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuncionesAuxiliares_denue.R
\name{denue_grid}
\alias{denue_grid}
\title{Obtiene establecimientos del DENUE en una area mayor a 5kms}
\usage{
denue_grid(lat1, lat2, lon1, lon2, token, metros = 5000, keyword = "todos",
  espacio_lat = 0.07, espacio_lon = 0.07, unicos = TRUE)
}
\arguments{
\item{lat1}{Esquina 1 de cuadro o área en latitud.}

\item{lat2}{Esquina 2 de cuadro o área en latitud.}

\item{lon1}{Esquina 1 de cuadro o área en longitud.}

\item{lon2}{Esquina 2 de cuadro o área en longitud.}

\item{token}{Token emitida por INEGI para acceder a API}

\item{metros}{Distancia en metros a la redonda para buscar establecimientos. Default = 5000, que es el máximo permitido por INEGI. Considera que si no cambias el espacio entre mediciones (en los otros parámetros), no vas a dibujar un cuadro totalmente cubierto por circulos.}

\item{keyword}{Palabra clave de establecimiento para buscar, a pasar a denue_inegi. Por default busca todos.}

\item{espacio_lat}{Espacio entre coordenadas, en latitud, por default = 0.07 grados.}

\item{espacio_lon}{Espacio entre coordenadas, en longitud, por default = 0.07 grados.}

\item{unicos}{Default = TRUE, solamente se exportan los negocios únicos (para evitar duplicar si sobrelapan los radios de las coordenadas).}
}
\value{
Data.frame
}
\description{
Regresa data.frame de datos de establecimientos registrados en el DENUE en un grid con dos o mas areas de 5kms (el limite de la llamada a INEGI).  
Llama a \code{hacer_grid}, ambas posible gracias a Arturo Cardenas \url{https://github.com/arturocm}.
}
\details{
Se hace un loop por cada par de coordenadas, que se sobrelapan en circulos alrededor de un cuadro proporcionado por las cuatro esquinas de los parametros. 
La función hacer_grid, usa máximos y mínimos de latitud y longitud para asignar pares, por lo que debes considerar con cuidad el área a mapear.
}
\examples{
\dontrun{
token<-"webservice_token"
latitud1 <- "25.669194"
latitud2 <- "25.169194"
longitud1 <- "-100.30990"
longitud2 <- "-101.20102"
Negocios <- denue_grid(latitud1, latitud2, longitud1, longitud2, token)
}

}
\author{
Arturo Cardenas
}

