% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{accessors}
\alias{accessors}
\alias{get_date_index_name}
\alias{get_date_index_name.default}
\alias{get_date_index_name.incidence2}
\alias{get_dates_name}
\alias{get_count_variable_name}
\alias{get_count_variable_name.default}
\alias{get_count_variable_name.incidence2}
\alias{get_count_value_name}
\alias{get_count_value_name.default}
\alias{get_count_value_name.incidence2}
\alias{get_group_names}
\alias{get_group_names.default}
\alias{get_group_names.incidence2}
\alias{get_date_index}
\alias{get_date_index.default}
\alias{get_date_index.incidence2}
\alias{get_dates}
\alias{get_count_variable}
\alias{get_count_variable.default}
\alias{get_count_variable.incidence2}
\alias{get_count_value}
\alias{get_count_value.default}
\alias{get_count_value.incidence2}
\alias{get_groups}
\alias{get_groups.default}
\alias{get_groups.incidence2}
\title{Access various elements of an incidence object}
\usage{
get_date_index_name(x, ...)

\method{get_date_index_name}{default}(x, ...)

\method{get_date_index_name}{incidence2}(x, ...)

get_dates_name(x, ...)

get_count_variable_name(x, ...)

\method{get_count_variable_name}{default}(x, ...)

\method{get_count_variable_name}{incidence2}(x, ...)

get_count_value_name(x, ...)

\method{get_count_value_name}{default}(x, ...)

\method{get_count_value_name}{incidence2}(x, ...)

get_group_names(x, ...)

\method{get_group_names}{default}(x, ...)

\method{get_group_names}{incidence2}(x, ...)

get_date_index(x, ...)

\method{get_date_index}{default}(x, ...)

\method{get_date_index}{incidence2}(x, ...)

get_dates(x, ...)

get_count_variable(x, ...)

\method{get_count_variable}{default}(x, ...)

\method{get_count_variable}{incidence2}(x, ...)

get_count_value(x, ...)

\method{get_count_value}{default}(x, ...)

\method{get_count_value}{incidence2}(x, ...)

get_groups(x, ...)

\method{get_groups}{default}(x, ...)

\method{get_groups}{incidence2}(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Not currently used.}
}
\value{
\itemize{
\item \code{get_date_index_name()}: The name of the date_index variable of x.
\item \code{get_dates_name()}: Alias for \code{get_date_index_name()}.
\item \code{get_count_variable_name()}: The name of the count variable of x.
\item \code{get_count_value_name()}: The name of the count value of x.
\item \code{get_group_names()}: The name(s) of the group variable(s) of x.
\item \code{get_date_index()}: The date_index variable of x.
\item \code{get_dates()}: Alias for \code{get_date_index()}.
\item \code{get_count_variable()}: The count variable of x.
\item \code{get_count_value()}: The count value of x.
\item \code{get_groups()}: List of the group variable(s) of x.
}
}
\description{
Access various elements of an incidence object
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    i <- incidence(
        dat,
        date_index = "date_of_onset",
        groups = c("gender", "hospital")
    )
    get_count_variable_name(i)
    get_group_names(i)
    get_dates_name(i)
}
\dontshow{data.table::setDTthreads(.old)}

}
