% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imsig.R
\name{imsig}
\alias{imsig}
\title{Estimate the relative abundance of tissue-infiltrating immune subpopulations abundances using gene expression data}
\usage{
imsig(exp, r = 0.6)
}
\arguments{
\item{exp}{Dataframe of transcriptomic data (natural scale) containing genes as rows and samples as columns. Note: Gene names should be set as row names and duplicates are not allowed. Missing values are not allowed within the expression matrix. Check example- head(example_data): \code{\link{example_data}}.}

\item{r}{Use a value between 0 and 1. Default is 0.6. This is a user defined correlation cut-off to perform feature selection (\code{\link{feature_select}}). Feature selection aids to enrich the prediction of relative abundance of immune cells by filtering off poorly correlated ImSig genes. To get an idea of what cut-off to use check the results of (\code{\link{gene_stat}} and choose a cut-off that displays high median correlation and maintains a high proportion of genes after feature selection.}
}
\value{
Relative abundance of immune cells across samples. Returns a dataframe.
}
\description{
Estimates the relative abundance of immune cells across patients/samples.
}
\examples{
cell_abundance = imsig (exp = example_data, r = 0.7)
head(cell_abundance)
}
\seealso{
\code{\link{feature_select}}, \code{\link{example_data}}
}
