% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunaut.R
\name{immunaut}
\alias{immunaut}
\title{Main function to carry out Immunaut Analysis}
\usage{
immunaut(dataset, settings = list())
}
\arguments{
\item{dataset}{A data frame representing the dataset on which the analysis will be performed. The dataset must
contain numeric columns for dimensionality reduction and clustering.}

\item{settings}{A named list containing settings for the analysis. If NULL, defaults will be used. The settings list may contain:

\describe{
\item{fileHeader}{A data frame mapping the original column names to remapped column names. Used for t-SNE input preparation.}
\item{selectedColumns}{Character vector of columns to be used for the analysis. Defaults to NULL.}
\item{cutOffColumnSize}{Numeric. The maximum size of the dataset in terms of columns. Defaults to 50,000.}
\item{excludedColumns}{Character vector of columns to exclude from the analysis. Defaults to NULL.}
\item{groupingVariables}{Character vector of columns to use for grouping the data during analysis. Defaults to NULL.}
\item{colorVariables}{Character vector of columns to use for coloring in the plots. Defaults to NULL.}
\item{preProcessDataset}{Character vector of preprocessing methods to apply (e.g., scaling, normalization). Defaults to NULL.}
\item{fontSize}{Numeric. Font size for plots. Defaults to 12.}
\item{pointSize}{Numeric. Size of points in plots. Defaults to 1.5.}
\item{theme}{Character. The ggplot2 theme to use (e.g., "theme_gray"). Defaults to "theme_gray".}
\item{colorPalette}{Character. Color palette for plots (e.g., "RdPu"). Defaults to "RdPu".}
\item{aspect_ratio}{Numeric. The aspect ratio of plots. Defaults to 1.}
\item{clusterType}{Character. The clustering method to use. Options are "Louvain", "Hierarchical", "Mclust", "Density". Defaults to "Louvain".}
\item{removeNA}{Logical. Whether to remove rows with NA values. Defaults to FALSE.}
\item{datasetAnalysisGrouped}{Logical. Whether to perform grouped dataset analysis. Defaults to FALSE.}
\item{plot_size}{Numeric. The size of the plot. Defaults to 12.}
\item{knn_clusters}{Numeric. The number of clusters for KNN-based clustering. Defaults to 250.}
\item{perplexity}{Numeric. The perplexity parameter for t-SNE. Defaults to NULL (automatically determined).}
\item{exaggeration_factor}{Numeric. The exaggeration factor for t-SNE. Defaults to NULL.}
\item{max_iter}{Numeric. The maximum number of iterations for t-SNE. Defaults to NULL.}
\item{theta}{Numeric. The Barnes-Hut approximation parameter for t-SNE. Defaults to NULL.}
\item{eta}{Numeric. The learning rate for t-SNE. Defaults to NULL.}
\item{clustLinkage}{Character. Linkage method for hierarchical clustering. Defaults to "ward.D2".}
\item{clustGroups}{Numeric. The number of groups for hierarchical clustering. Defaults to 9.}
\item{distMethod}{Character. Distance metric for clustering. Defaults to "euclidean".}
\item{minPtsAdjustmentFactor}{Numeric. Adjustment factor for the minimum points in DBSCAN clustering. Defaults to 1.}
\item{epsQuantile}{Numeric. Quantile to compute the epsilon parameter for DBSCAN clustering. Defaults to 0.9.}
\item{assignOutliers}{Logical. Whether to assign outliers in the clustering step. Defaults to TRUE.}
\item{excludeOutliers}{Logical. Whether to exclude outliers from clustering. Defaults to TRUE.}
\item{legendPosition}{Character. Position of the legend in plots (e.g., "right", "bottom"). Defaults to "right".}
\item{datasetAnalysisClustLinkage}{Character. Linkage method for dataset-level analysis. Defaults to "ward.D2".}
\item{datasetAnalysisType}{Character. Type of dataset analysis (e.g., "heatmap"). Defaults to "heatmap".}
\item{datasetAnalysisRemoveOutliersDownstream}{Logical. Whether to remove outliers during downstream dataset analysis (e.g., machine learning). Defaults to FALSE.}
\item{datasetAnalysisSortColumn}{Character. The column used to sort dataset analysis results. Defaults to "cluster".}
\item{datasetAnalysisClustOrdering}{Numeric. The order of clusters for analysis. Defaults to 1.}
\item{anyNAValues}{Logical. Whether the dataset contains NA values. Defaults to FALSE.}
\item{categoricalVariables}{Logical. Whether the dataset contains categorical variables. Defaults to FALSE.}
\item{resolution_increments}{Numeric vector. The resolution increments to be used for Louvain clustering. Defaults to \code{c(0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5)}.}
\item{min_modularities}{Numeric vector. The minimum modularities to test for clustering. Defaults to \code{c(0.4, 0.5, 0.6, 0.7, 0.8, 0.85, 0.9)}.}
\item{target_clusters_range}{Numeric vector. The range of acceptable clusters to identify. Defaults to \code{c(3, 6)}.}
\item{pickBestClusterMethod}{Character. The method to use for picking the best clustering result ("Modularity", "Silhouette", or "SIMON"). Defaults to "Modularity".}
\item{weights}{List. Weights for evaluating clusters based on \code{AUROC}, \code{modularity}, and \code{silhouette}. Defaults to \code{list(AUROC = 0.5, modularity = 0.3, silhouette = 0.2)}. These weights are applied to help choose the most relevant clusters based on user goals:
\describe{
\item{\code{AUROC}}{Weight for predictive performance (area under the receiver operating characteristic curve). Prioritize this when predictive accuracy is the main goal. For predictive analysis, a recommended configuration could be \code{list(AUROC = 0.8, modularity = 0.1, silhouette = 0.1)}.}
\item{\code{modularity}}{Weight for modularity score, which indicates the strength of clustering. Higher modularity suggests that clusters are well-separated. To prioritize well-separated clusters, use a configuration like \code{list(AUROC = 0.4, modularity = 0.4, silhouette = 0.2)}.}
\item{\code{silhouette}}{Weight for silhouette score, a measure of cohesion within clusters. Useful when cluster cohesion and interpretability are desired. For balanced clusters, a suggested configuration is \code{list(AUROC = 0.4, modularity = 0.3, silhouette = 0.3)}.}
}}
}}
}
\value{
A list containing the following:
\itemize{
\item \code{tsne_calc}: The t-SNE results object.
\item \code{tsne_clust}: The clustering results.
\item \code{dataset}: A list containing the original dataset, the preprocessed dataset, and a dataset with machine learning-ready data.
\item \code{clusters}: The final cluster assignments.
\item \code{settings}: The list of settings used for the analysis.
}
}
\description{
This function performs clustering and dimensionality reduction analysis on a dataset using user-defined settings.
It handles various preprocessing steps, dimensionality reduction via t-SNE, multiple clustering methods, and
generates associated plots based on user-defined or default settings.
}
\examples{
\donttest{
  data <- matrix(runif(2000), ncol=20)
  settings <- list(clusterType = "Louvain", 
  resolution_increments = c(0.05, 0.1), 
  min_modularities = c(0.3, 0.5))
  result <- immunaut(data.frame(data), settings)
  print(result$clusters)
}

}
