% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{convolve}
\alias{convolve}
\title{Convolve image by filter.}
\usage{
convolve(im, filter, boundary_conditions = TRUE, normalise = FALSE)
}
\arguments{
\item{im}{an image}

\item{filter}{a filter (another image)}

\item{boundary_conditions}{= the border condition type (0=zero, 1=dirichlet)}

\item{normalise}{= normalise filter (default FALSE)}
}
\description{
The result  res of the convolution of an image img by filter flt is defined to be:
      \eqn{res(x,y,z) = sum_{i,j,k} img(x-i,y-j,z-k)*flt(i,j,k)}
}
\examples{
#Edge filter
filter <- as.cimg(function(x,y) sign(x-5),10,10) 
layout(t(1:2))
#Convolution vs. correlation 
correlate(boats,filter) \%>\% plot(main="Correlation")
convolve(boats,filter) \%>\% plot(main="Convolution")
}
\seealso{
correlate
}

