% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.ggplot.R
\name{im.ggplot}
\alias{im.ggplot}
\title{Visualize a Raster Image Using ggplot2}
\usage{
im.ggplot(input_raster, layerfill = 1)
}
\arguments{
\item{input_raster}{A `SpatRaster` object representing the input raster image.}

\item{layerfill}{An integer indicating the layer index to be used for coloring the raster (default: 1).}
}
\value{
A `ggplot` object displaying the raster image.
}
\description{
This function converts a `SpatRaster` object into a `ggplot2` visualization, allowing for
flexible raster plotting with color interpolation.
}
\details{
This function extracts raster values, converts them into a data frame, and uses `ggplot2`
to visualize the raster with a viridis color scale.

- If `layerfill` is not provided, the function defaults to using the first layer.
- The function automatically handles coordinate extraction (`x` and `y` values).
- Colors are applied using `scale_fill_viridis()`, ensuring good perceptual readability.
}
\examples{
library(terra)
library(ggplot2)

# Create a sample raster
r <- rast(nrows = 10, ncols = 10)
values(r) <- matrix(runif(100), nrow = 10)

# Generate a ggplot visualization
im.ggplot(r)
}
\seealso{
[im.classify()], [im.dvi()]
}
