% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{disjoint_union}
\alias{disjoint_union}
\alias{\%du\%}
\title{Disjoint union of graphs}
\usage{
disjoint_union(...)

x \%du\% y
}
\arguments{
\item{\dots}{Graph objects or lists of graph objects.}

\item{x, y}{Graph objects.}
}
\value{
A new graph object.
}
\description{
The union of two or more graphs are created. The graphs are assumed to have
disjoint vertex sets.
}
\details{
\code{disjoint_union()} creates a union of two or more disjoint graphs.
Thus first the vertices in the second, third, etc. graphs are relabeled to
have completely disjoint graphs. Then a simple union is created. This
function can also be used via the \verb{\%du\%} operator.

\code{graph.disjont.union} handles graph, vertex and edge attributes.  In
particular, it merges vertex and edge attributes using the basic \code{c()}
function. For graphs that lack some vertex/edge attribute, the corresponding
values in the new graph are set to \code{NA}. Graph attributes are simply
copied to the result. If this would result a name clash, then they are
renamed by adding suffixes: _1, _2, etc.

Note that if both graphs have vertex names (i.e. a \code{name} vertex
attribute), then the concatenated vertex names might be non-unique in the
result. A warning is given if this happens.

An error is generated if some input graphs are directed and others are
undirected.
}
\examples{

## A star and a ring
g1 <- make_star(10, mode = "undirected")
V(g1)$name <- letters[1:10]
g2 <- make_ring(10)
V(g2)$name <- letters[11:20]
print_all(g1 \%du\% g2)
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()},
\code{\link{vertex}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{functions for manipulating graph structure}
\keyword{graphs}
